/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class EscherPlaceholder
extends EscherRecord {
    public static final short RECORD_ID = RecordTypes.OEPlaceholderAtom.typeID;
    public static final String RECORD_DESCRIPTION = "msofbtClientTextboxPlaceholder";
    private int position = -1;
    private byte placementId = 0;
    private byte size = 0;
    private short unused = 0;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        this.position = LittleEndian.getInt((byte[])data, (int)(offset + 8));
        this.placementId = data[offset + 12];
        this.size = data[offset + 13];
        this.unused = LittleEndian.getShort((byte[])data, (int)(offset + 14));
        assert (bytesRemaining + 8 == 16);
        return bytesRemaining + 8;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), (EscherRecord)this);
        LittleEndian.putShort((byte[])data, (int)offset, (short)this.getOptions());
        LittleEndian.putShort((byte[])data, (int)(offset + 2), (short)this.getRecordId());
        LittleEndian.putInt((byte[])data, (int)(offset + 4), (int)8);
        LittleEndian.putInt((byte[])data, (int)(offset + 8), (int)this.position);
        LittleEndian.putByte((byte[])data, (int)(offset + 12), (int)this.placementId);
        LittleEndian.putByte((byte[])data, (int)(offset + 13), (int)this.size);
        LittleEndian.putShort((byte[])data, (int)(offset + 14), (short)this.unused);
        listener.afterRecordSerialize(offset + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), (EscherRecord)this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public String getRecordName() {
        return "ClientTextboxPlaceholder";
    }

    protected Object[][] getAttributeMap() {
        return new Object[][]{{"position", this.position}, {"placementId", this.placementId}, {"placehoder size", this.size}, {"unused", this.unused}};
    }
}

