/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.discovery.gce;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.cloud.gce.GceInstancesServiceImpl;
import org.elasticsearch.cloud.gce.GceMetadataService;
import org.elasticsearch.cloud.gce.network.GceNameResolver;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.gce.GceSeedHostsProvider;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.TransportService;

public class GceDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
Closeable {
    private static final boolean ALLOW_REROUTE_GCE_SETTINGS = Booleans.parseBoolean((String)System.getProperty("es.allow_reroute_gce_settings", "false"));
    public static final String GCE = "gce";
    protected final Settings settings;
    private static final Logger logger = LogManager.getLogger(GceDiscoveryPlugin.class);
    private final SetOnce<GceInstancesService> gceInstancesService = new SetOnce();

    public GceDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        logger.trace("starting gce discovery plugin...");
    }

    protected GceInstancesService createGceInstancesService() {
        return new GceInstancesServiceImpl(this.settings);
    }

    public Map<String, Supplier<SeedHostsProvider>> getSeedHostProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(GCE, () -> {
            this.gceInstancesService.set((Object)this.createGceInstancesService());
            return new GceSeedHostsProvider(this.settings, (GceInstancesService)this.gceInstancesService.get(), transportService, networkService);
        });
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settingsToUse) {
        logger.debug("Register _gce_, _gce:xxx network names");
        return new GceNameResolver(new GceMetadataService(settingsToUse));
    }

    public List<Setting<?>> getSettings() {
        ArrayList<Setting> settingList = new ArrayList<Setting>(Arrays.asList(GceInstancesService.PROJECT_SETTING, GceInstancesService.ZONE_SETTING, GceSeedHostsProvider.TAGS_SETTING, GceInstancesService.REFRESH_SETTING, GceInstancesService.RETRY_SETTING, GceInstancesService.MAX_WAIT_SETTING));
        if (ALLOW_REROUTE_GCE_SETTINGS) {
            settingList.add(GceMetadataService.GCE_HOST);
            settingList.add(GceInstancesServiceImpl.GCE_ROOT_URL);
        }
        return Collections.unmodifiableList(settingList);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.gceInstancesService.get()));
    }
}

