/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.gce;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.NetworkInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.transport.TransportService;

public class GceSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(GceSeedHostsProvider.class);
    public static final Setting<List<String>> TAGS_SETTING = Setting.listSetting((String)"discovery.gce.tags", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private final GceInstancesService gceInstancesService;
    private TransportService transportService;
    private NetworkService networkService;
    private final String project;
    private final List<String> zones;
    private final List<String> tags;
    private final TimeValue refreshInterval;
    private long lastRefresh;
    private List<TransportAddress> cachedDynamicHosts;

    public GceSeedHostsProvider(Settings settings, GceInstancesService gceInstancesService, TransportService transportService, NetworkService networkService) {
        this.settings = settings;
        this.gceInstancesService = gceInstancesService;
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = (TimeValue)GceInstancesService.REFRESH_SETTING.get(settings);
        this.project = gceInstancesService.projectId();
        this.zones = gceInstancesService.zones();
        this.tags = (List)TAGS_SETTING.get(settings);
        if (logger.isDebugEnabled()) {
            logger.debug("using tags {}", new Object[]{this.tags});
        }
    }

    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        if (this.project == null || this.project.isEmpty() || this.zones == null || this.zones.isEmpty()) {
            throw new IllegalArgumentException("one or more gce discovery settings are missing. Check elasticsearch.yml file. Should have [" + GceInstancesService.PROJECT_SETTING.getKey() + "] and [" + GceInstancesService.ZONE_SETTING.getKey() + "].");
        }
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDynamicHosts != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("using cache to retrieve node list");
                }
                return this.cachedDynamicHosts;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        logger.debug("start building nodes list using GCE API");
        this.cachedDynamicHosts = new ArrayList<TransportAddress>();
        String ipAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddresses(((List)NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(this.settings)).toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY));
            if (inetAddress != null) {
                ipAddress = NetworkAddress.format((InetAddress)inetAddress);
            }
        }
        catch (IOException inetAddress) {
            // empty catch block
        }
        try {
            Collection<Instance> instances = this.gceInstancesService.instances();
            if (instances == null) {
                logger.trace("no instance found for project [{}], zones [{}].", new Object[]{this.project, this.zones});
                return this.cachedDynamicHosts;
            }
            for (Instance instance : instances) {
                String name = instance.getName();
                String type = instance.getMachineType();
                String status = instance.getStatus();
                logger.trace("gce instance {} with status {} found.", new Object[]{name, status});
                if ("TERMINATED".equals(status)) {
                    logger.debug("node {} is TERMINATED. Ignoring", new Object[]{name});
                    continue;
                }
                boolean filterByTag = false;
                if (!this.tags.isEmpty()) {
                    logger.trace("start filtering instance {} with tags {}.", new Object[]{name, this.tags});
                    if (instance.getTags() == null || instance.getTags().isEmpty() || instance.getTags().getItems() == null || instance.getTags().getItems().isEmpty()) {
                        logger.trace("no tags for this instance but we asked for tags. {} won't be part of the cluster.", new Object[]{name});
                        filterByTag = true;
                    } else {
                        logger.trace("comparing instance tags {} with tags filter {}.", new Object[]{instance.getTags().getItems(), this.tags});
                        for (String tag : this.tags) {
                            boolean found = false;
                            for (String instancetag : instance.getTags().getItems()) {
                                if (!instancetag.equals(tag)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            filterByTag = true;
                            break;
                        }
                    }
                }
                if (filterByTag) {
                    logger.trace("filtering out instance {} based tags {}, not part of {}", new Object[]{name, this.tags, instance.getTags() == null || instance.getTags().getItems() == null ? "" : instance.getTags()});
                    continue;
                }
                logger.trace("instance {} with tags {} is added to discovery", new Object[]{name, this.tags});
                String ip_public = null;
                String ip_private = null;
                List interfaces = instance.getNetworkInterfaces();
                for (NetworkInterface networkInterface : interfaces) {
                    if (ip_public == null && networkInterface.getAccessConfigs() != null) {
                        for (AccessConfig accessConfig : networkInterface.getAccessConfigs()) {
                            if (!org.elasticsearch.common.Strings.hasText((String)accessConfig.getNatIP())) continue;
                            ip_public = accessConfig.getNatIP();
                            break;
                        }
                    }
                    if (ip_private == null) {
                        ip_private = networkInterface.getNetworkIP();
                    }
                    if (ip_private == null || ip_public == null) continue;
                    break;
                }
                try {
                    TransportAddress[] addresses;
                    if (ip_private.equals(ipAddress)) {
                        logger.trace("current node found. Ignoring {} - {}", new Object[]{name, ip_private});
                        continue;
                    }
                    String address = ip_private;
                    if (instance.getMetadata() != null && instance.getMetadata().containsKey((Object)"es_port")) {
                        Object es_port = instance.getMetadata().get((Object)"es_port");
                        logger.trace("es_port is defined with {}", new Object[]{es_port});
                        if (es_port instanceof String) {
                            String string = (String)es_port;
                            address = address.concat(":").concat(string);
                        } else {
                            logger.trace("es_port is instance of {}. Ignoring...", new Object[]{es_port.getClass().getName()});
                        }
                    }
                    for (TransportAddress transportAddress : addresses = this.transportService.addressesFromString(address)) {
                        logger.trace("adding {}, type {}, address {}, transport_address {}, status {}", new Object[]{name, type, ip_private, transportAddress, status});
                        this.cachedDynamicHosts.add(transportAddress);
                    }
                }
                catch (Exception e) {
                    String finalIpPrivate = ip_private;
                    logger.warn(() -> Strings.format((String)"failed to add %s, address %s", (Object[])new Object[]{name, finalIpPrivate}), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.warn("exception caught during discovery", (Throwable)e);
        }
        logger.debug("{} addresses added", new Object[]{this.cachedDynamicHosts.size()});
        logger.debug("using transport addresses {}", new Object[]{this.cachedDynamicHosts});
        return this.cachedDynamicHosts;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

