/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.discovery.gce;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.ClassInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.cloud.gce.GceInstancesServiceImpl;
import org.elasticsearch.cloud.gce.GceMetadataService;
import org.elasticsearch.cloud.gce.network.GceNameResolver;
import org.elasticsearch.cloud.gce.util.Access;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.gce.GceUnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.TransportService;

public class GceDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
Closeable {
    private static final boolean ALLOW_REROUTE_GCE_SETTINGS = Booleans.parseBoolean((String)System.getProperty("es.allow_reroute_gce_settings", "false"));
    public static final String GCE = "gce";
    protected final Settings settings;
    private static final Logger logger = LogManager.getLogger(GceDiscoveryPlugin.class);
    private final SetOnce<GceInstancesService> gceInstancesService = new SetOnce();

    public GceDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        logger.trace("starting gce discovery plugin...");
    }

    protected GceInstancesService createGceInstancesService() {
        return new GceInstancesServiceImpl(this.settings);
    }

    public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(GCE, () -> {
            this.gceInstancesService.set((Object)this.createGceInstancesService());
            return new GceUnicastHostsProvider(this.settings, (GceInstancesService)this.gceInstancesService.get(), transportService, networkService);
        });
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        logger.debug("Register _gce_, _gce:xxx network names");
        return new GceNameResolver(new GceMetadataService(settings));
    }

    public List<Setting<?>> getSettings() {
        ArrayList<Setting> settings = new ArrayList<Setting>(Arrays.asList(GceInstancesService.PROJECT_SETTING, GceInstancesService.ZONE_SETTING, GceUnicastHostsProvider.TAGS_SETTING, GceInstancesService.REFRESH_SETTING, GceInstancesService.RETRY_SETTING, GceInstancesService.MAX_WAIT_SETTING));
        if (ALLOW_REROUTE_GCE_SETTINGS) {
            settings.add(GceMetadataService.GCE_HOST);
            settings.add(GceInstancesServiceImpl.GCE_ROOT_URL);
        }
        return Collections.unmodifiableList(settings);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.gceInstancesService.get()});
    }

    static {
        Access.doPrivilegedVoid(() -> ClassInfo.of(HttpHeaders.class, (boolean)true));
    }
}

