/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.gce;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.NetworkInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class GceUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    public static final Setting<List<String>> TAGS_SETTING = Setting.listSetting((String)"discovery.gce.tags", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private final GceInstancesService gceInstancesService;
    private TransportService transportService;
    private NetworkService networkService;
    private final String project;
    private final List<String> zones;
    private final List<String> tags;
    private final TimeValue refreshInterval;
    private long lastRefresh;
    private List<TransportAddress> cachedDynamicHosts;

    public GceUnicastHostsProvider(Settings settings, GceInstancesService gceInstancesService, TransportService transportService, NetworkService networkService) {
        this.settings = settings;
        this.gceInstancesService = gceInstancesService;
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = (TimeValue)GceInstancesService.REFRESH_SETTING.get(settings);
        this.project = gceInstancesService.projectId();
        this.zones = gceInstancesService.zones();
        this.tags = (List)TAGS_SETTING.get(settings);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using tags {}", this.tags);
        }
    }

    public List<TransportAddress> buildDynamicHosts(UnicastHostsProvider.HostsResolver hostsResolver) {
        if (this.project == null || this.project.isEmpty() || this.zones == null || this.zones.isEmpty()) {
            throw new IllegalArgumentException("one or more gce discovery settings are missing. Check elasticsearch.yml file. Should have [" + GceInstancesService.PROJECT_SETTING.getKey() + "] and [" + GceInstancesService.ZONE_SETTING.getKey() + "].");
        }
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedDynamicHosts != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve node list");
                }
                return this.cachedDynamicHosts;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        this.logger.debug("start building nodes list using GCE API");
        this.cachedDynamicHosts = new ArrayList<TransportAddress>();
        String ipAddress = null;
        try {
            InetAddress inetAddress = this.networkService.resolvePublishHostAddresses(((List)NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(this.settings)).toArray(Strings.EMPTY_ARRAY));
            if (inetAddress != null) {
                ipAddress = NetworkAddress.format((InetAddress)inetAddress);
            }
        }
        catch (IOException inetAddress) {
            // empty catch block
        }
        try {
            Collection<Instance> instances = this.gceInstancesService.instances();
            if (instances == null) {
                this.logger.trace("no instance found for project [{}], zones [{}].", (Object)this.project, this.zones);
                return this.cachedDynamicHosts;
            }
            for (Instance instance : instances) {
                String name = instance.getName();
                String type = instance.getMachineType();
                String status = instance.getStatus();
                this.logger.trace("gce instance {} with status {} found.", (Object)name, (Object)status);
                if ("TERMINATED".equals(status)) {
                    this.logger.debug("node {} is TERMINATED. Ignoring", (Object)name);
                    continue;
                }
                boolean filterByTag = false;
                if (!this.tags.isEmpty()) {
                    this.logger.trace("start filtering instance {} with tags {}.", (Object)name, this.tags);
                    if (instance.getTags() == null || instance.getTags().isEmpty() || instance.getTags().getItems() == null || instance.getTags().getItems().isEmpty()) {
                        this.logger.trace("no tags for this instance but we asked for tags. {} won't be part of the cluster.", (Object)name);
                        filterByTag = true;
                    } else {
                        this.logger.trace("comparing instance tags {} with tags filter {}.", (Object)instance.getTags().getItems(), this.tags);
                        for (String tag : this.tags) {
                            boolean found = false;
                            for (String instancetag : instance.getTags().getItems()) {
                                if (!instancetag.equals(tag)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            filterByTag = true;
                            break;
                        }
                    }
                }
                if (filterByTag) {
                    this.logger.trace("filtering out instance {} based tags {}, not part of {}", (Object)name, this.tags, (Object)(instance.getTags() == null || instance.getTags().getItems() == null ? "" : instance.getTags()));
                    continue;
                }
                this.logger.trace("instance {} with tags {} is added to discovery", (Object)name, this.tags);
                String ip_public = null;
                String ip_private = null;
                List interfaces = instance.getNetworkInterfaces();
                for (NetworkInterface networkInterface : interfaces) {
                    if (ip_public == null && networkInterface.getAccessConfigs() != null) {
                        for (AccessConfig accessConfig : networkInterface.getAccessConfigs()) {
                            if (!Strings.hasText((String)accessConfig.getNatIP())) continue;
                            ip_public = accessConfig.getNatIP();
                            break;
                        }
                    }
                    if (ip_private == null) {
                        ip_private = networkInterface.getNetworkIP();
                    }
                    if (ip_private == null || ip_public == null) continue;
                    break;
                }
                try {
                    TransportAddress[] addresses;
                    if (ip_private.equals(ipAddress)) {
                        this.logger.trace("current node found. Ignoring {} - {}", (Object)name, (Object)ip_private);
                        continue;
                    }
                    String address = ip_private;
                    if (instance.getMetadata() != null && instance.getMetadata().containsKey((Object)"es_port")) {
                        Object es_port = instance.getMetadata().get((Object)"es_port");
                        this.logger.trace("es_port is defined with {}", es_port);
                        if (es_port instanceof String) {
                            address = address.concat(":").concat((String)es_port);
                        } else {
                            this.logger.trace("es_port is instance of {}. Ignoring...", (Object)es_port.getClass().getName());
                        }
                    }
                    for (TransportAddress transportAddress : addresses = this.transportService.addressesFromString(address, 1)) {
                        this.logger.trace("adding {}, type {}, address {}, transport_address {}, status {}", (Object)name, (Object)type, (Object)ip_private, (Object)transportAddress, (Object)status);
                        this.cachedDynamicHosts.add(transportAddress);
                    }
                }
                catch (Exception e) {
                    String finalIpPrivate = ip_private;
                    this.logger.warn(() -> new ParameterizedMessage("failed to add {}, address {}", (Object)name, (Object)finalIpPrivate), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("exception caught during discovery", (Throwable)e);
        }
        this.logger.debug("{} addresses added", (Object)this.cachedDynamicHosts.size());
        this.logger.debug("using transport addresses {}", this.cachedDynamicHosts);
        return this.cachedDynamicHosts;
    }

    static final class Status {
        private static final String TERMINATED = "TERMINATED";

        Status() {
        }
    }
}

