/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.gce;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.testing.auth.oauth2.MockGoogleCredential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cloud.gce.util.Access;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.TimeValue;

public class RetryHttpInitializerWrapper
implements HttpRequestInitializer {
    private TimeValue maxWait;
    private static final Logger logger = ESLoggerFactory.getLogger((String)RetryHttpInitializerWrapper.class.getName());
    private final Credential wrappedCredential;
    private final Sleeper sleeper;

    public RetryHttpInitializerWrapper(Credential wrappedCredential) {
        this(wrappedCredential, Sleeper.DEFAULT, TimeValue.timeValueMillis((long)900000L));
    }

    public RetryHttpInitializerWrapper(Credential wrappedCredential, TimeValue maxWait) {
        this(wrappedCredential, Sleeper.DEFAULT, maxWait);
    }

    RetryHttpInitializerWrapper(Credential wrappedCredential, Sleeper sleeper, TimeValue maxWait) {
        this.wrappedCredential = Objects.requireNonNull(wrappedCredential);
        this.sleeper = sleeper;
        this.maxWait = maxWait;
    }

    static MockGoogleCredential.Builder newMockCredentialBuilder() {
        return Access.doPrivileged(MockGoogleCredential.Builder::new);
    }

    public void initialize(HttpRequest httpRequest) {
        HttpBackOffUnsuccessfulResponseHandler backoffHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff.Builder().setMaxElapsedTimeMillis((int)this.maxWait.getMillis()).build()).setSleeper(this.sleeper);
        httpRequest.setInterceptor((HttpExecuteInterceptor)this.wrappedCredential);
        httpRequest.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)backoffHandler){
            int retry = 0;
            final /* synthetic */ HttpUnsuccessfulResponseHandler val$backoffHandler;
            {
                this.val$backoffHandler = httpUnsuccessfulResponseHandler;
            }

            public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                if (RetryHttpInitializerWrapper.this.wrappedCredential.handleResponse(request, response, supportsRetry)) {
                    return true;
                }
                if (this.val$backoffHandler.handleResponse(request, response, supportsRetry)) {
                    logger.debug("Retrying [{}] times : [{}]", (Object)this.retry, (Object)request.getUrl());
                    return true;
                }
                return false;
            }
        });
        httpRequest.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff.Builder().setMaxElapsedTimeMillis((int)this.maxWait.getMillis()).build()).setSleeper(this.sleeper));
    }
}

