/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.discovery.gce;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.ClassInfo;
import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.cloud.gce.GceInstancesServiceImpl;
import org.elasticsearch.cloud.gce.GceMetadataService;
import org.elasticsearch.cloud.gce.network.GceNameResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.gce.GceUnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GceDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
Closeable {
    public static final String GCE = "gce";
    private final Settings settings;
    private static final Logger logger = Loggers.getLogger(GceDiscoveryPlugin.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private final SetOnce<GceInstancesService> gceInstancesService = new SetOnce();

    public GceDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        logger.trace("starting gce discovery plugin...");
    }

    public Map<String, Supplier<Discovery>> getDiscoveryTypes(ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, ClusterService clusterService, UnicastHostsProvider hostsProvider) {
        return Collections.singletonMap(GCE, () -> new ZenDiscovery(this.settings, threadPool, transportService, namedWriteableRegistry, clusterService, hostsProvider));
    }

    protected GceInstancesService createGceInstancesService() {
        return new GceInstancesServiceImpl(this.settings);
    }

    public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(GCE, () -> {
            this.gceInstancesService.set((Object)this.createGceInstancesService());
            return new GceUnicastHostsProvider(this.settings, (GceInstancesService)this.gceInstancesService.get(), transportService, networkService);
        });
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        logger.debug("Register _gce_, _gce:xxx network names");
        return new GceNameResolver(settings, new GceMetadataService(settings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(GceInstancesService.PROJECT_SETTING, GceInstancesService.ZONE_SETTING, GceUnicastHostsProvider.TAGS_SETTING, GceInstancesService.REFRESH_SETTING, GceInstancesService.RETRY_SETTING, GceInstancesService.MAX_WAIT_SETTING);
    }

    public Settings additionalSettings() {
        String discoveryType = (String)DiscoveryModule.DISCOVERY_TYPE_SETTING.get(this.settings);
        if (discoveryType.equals(GCE)) {
            deprecationLogger.deprecated("Using " + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + " setting to set hosts provider is deprecated. Set \"" + DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey() + ": " + GCE + "\" instead", new Object[0]);
            if (!DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.exists(this.settings)) {
                return Settings.builder().put(DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey(), GCE).build();
            }
        }
        return Settings.EMPTY;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.gceInstancesService.get()});
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ClassInfo.of(HttpHeaders.class, (boolean)true);
                return null;
            }
        });
    }
}

