/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.gce;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.function.Function;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class GceMetadataService
extends AbstractLifecycleComponent {
    public static final Setting<String> GCE_HOST = new Setting("cloud.gce.host", "http://metadata.google.internal", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    private HttpTransport gceHttpTransport;

    public GceMetadataService(Settings settings) {
        super(settings);
    }

    protected synchronized HttpTransport getGceHttpTransport() throws GeneralSecurityException, IOException {
        if (this.gceHttpTransport == null) {
            this.gceHttpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        return this.gceHttpTransport;
    }

    public String metadata(String metadataPath) throws IOException, URISyntaxException {
        final URI urlMetadataNetwork = new URI((String)GCE_HOST.get(this.settings)).resolve("/computeMetadata/v1/instance/").resolve(metadataPath);
        this.logger.debug("get metadata from [{}]", (Object)urlMetadataNetwork);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            HttpHeaders headers = AccessController.doPrivileged(new PrivilegedExceptionAction<HttpHeaders>(){

                @Override
                public HttpHeaders run() throws IOException {
                    return new HttpHeaders();
                }
            });
            GenericUrl genericUrl = AccessController.doPrivileged(new PrivilegedAction<GenericUrl>(){

                @Override
                public GenericUrl run() {
                    return new GenericUrl(urlMetadataNetwork);
                }
            });
            headers.put("Metadata-Flavor", (Object)"Google");
            HttpResponse response = this.getGceHttpTransport().createRequestFactory().buildGetRequest(genericUrl).setHeaders(headers).execute();
            String metadata = response.parseAsString();
            this.logger.debug("metadata found [{}]", (Object)metadata);
            return metadata;
        }
        catch (Exception e) {
            throw new IOException("failed to fetch metadata from [" + urlMetadataNetwork + "]", e);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
        if (this.gceHttpTransport != null) {
            try {
                this.gceHttpTransport.shutdown();
            }
            catch (IOException e) {
                this.logger.warn("unable to shutdown GCE Http Transport", (Throwable)e);
            }
            this.gceHttpTransport = null;
        }
    }

    protected void doClose() {
    }
}

