/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.discovery.gce;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.ClassInfo;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.cloud.gce.GceMetadataService;
import org.elasticsearch.cloud.gce.GceModule;
import org.elasticsearch.cloud.gce.network.GceNameResolver;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.gce.GceUnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;

public class GceDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin {
    public static final String GCE = "gce";
    private final Settings settings;
    protected final Logger logger = Loggers.getLogger(GceDiscoveryPlugin.class);

    public GceDiscoveryPlugin(Settings settings) {
        this.settings = settings;
        this.logger.trace("starting gce discovery plugin...");
    }

    public Collection<Module> createGuiceModules() {
        return Collections.singletonList(new GceModule(this.settings));
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        this.logger.debug("Register gce compute service");
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        services.add(GceModule.getComputeServiceImpl());
        return services;
    }

    public void onModule(DiscoveryModule discoveryModule) {
        this.logger.debug("Register gce discovery type and gce unicast provider");
        discoveryModule.addDiscoveryType(GCE, ZenDiscovery.class);
        discoveryModule.addUnicastHostProvider(GCE, GceUnicastHostsProvider.class);
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        this.logger.debug("Register _gce_, _gce:xxx network names");
        return new GceNameResolver(settings, new GceMetadataService(settings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(GceInstancesService.PROJECT_SETTING, GceInstancesService.ZONE_SETTING, GceUnicastHostsProvider.TAGS_SETTING, GceInstancesService.REFRESH_SETTING, GceInstancesService.RETRY_SETTING, GceInstancesService.MAX_WAIT_SETTING);
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ClassInfo.of(HttpHeaders.class, (boolean)true);
                return null;
            }
        });
    }
}

