/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.gce;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceList;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cloud.gce.GceInstancesService;
import org.elasticsearch.cloud.gce.GceMetadataService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.gce.RetryHttpInitializerWrapper;

public class GceInstancesServiceImpl
extends AbstractLifecycleComponent
implements GceInstancesService {
    public static final Setting<Boolean> GCE_VALIDATE_CERTIFICATES = Setting.boolSetting((String)"cloud.gce.validate_certificates", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> GCE_ROOT_URL = new Setting("cloud.gce.root_url", "https://www.googleapis.com", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    private final String project;
    private final List<String> zones;
    private Compute client;
    private TimeValue refreshInterval = null;
    private long lastRefresh;
    private HttpTransport gceHttpTransport;
    private JsonFactory gceJsonFactory;
    private final boolean validateCerts;

    @Override
    public Collection<Instance> instances() {
        this.logger.debug("get instances for project [{}], zones [{}]", (Object)this.project, this.zones);
        List instances = this.zones.stream().map(zoneId -> {
            try {
                InstanceList instanceList;
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)new SpecialPermission());
                }
                return (instanceList = AccessController.doPrivileged(new PrivilegedExceptionAction<InstanceList>(){

                    @Override
                    public InstanceList run() throws Exception {
                        Compute.Instances.List list = GceInstancesServiceImpl.this.client().instances().list(GceInstancesServiceImpl.this.project, zoneId);
                        return (InstanceList)list.execute();
                    }
                })).isEmpty() || instanceList.getItems() == null ? Collections.emptyList() : instanceList.getItems();
            }
            catch (PrivilegedActionException e) {
                this.logger.warn(() -> new ParameterizedMessage("Problem fetching instance list for zone {}", zoneId), (Throwable)e);
                this.logger.debug("Full exception:", (Throwable)e);
                return Collections.emptyList();
            }
        }).reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        });
        if (instances.isEmpty()) {
            this.logger.warn("disabling GCE discovery. Can not get list of nodes");
        }
        return instances;
    }

    @Inject
    public GceInstancesServiceImpl(Settings settings) {
        super(settings);
        this.project = (String)PROJECT_SETTING.get(settings);
        this.zones = (List)ZONE_SETTING.get(settings);
        this.validateCerts = (Boolean)GCE_VALIDATE_CERTIFICATES.get(settings);
    }

    protected synchronized HttpTransport getGceHttpTransport() throws GeneralSecurityException, IOException {
        if (this.gceHttpTransport == null) {
            this.gceHttpTransport = this.validateCerts ? GoogleNetHttpTransport.newTrustedTransport() : new NetHttpTransport.Builder().doNotValidateCertificate().build();
        }
        return this.gceHttpTransport;
    }

    public synchronized Compute client() {
        if (this.refreshInterval != null && this.refreshInterval.millis() != 0L) {
            if (this.client != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve client");
                }
                return this.client;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        try {
            this.gceJsonFactory = new JacksonFactory();
            this.logger.info("starting GCE discovery service");
            String tokenServerEncodedUrl = (String)GceMetadataService.GCE_HOST.get(this.settings) + "/computeMetadata/v1/instance/service-accounts/default/token";
            final ComputeCredential credential = new ComputeCredential.Builder(this.getGceHttpTransport(), this.gceJsonFactory).setTokenServerEncodedUrl(tokenServerEncodedUrl).build();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    credential.refreshToken();
                    return null;
                }
            });
            this.logger.debug("token [{}] will expire in [{}] s", (Object)credential.getAccessToken(), (Object)credential.getExpiresInSeconds());
            if (credential.getExpiresInSeconds() != null) {
                this.refreshInterval = TimeValue.timeValueSeconds((long)(credential.getExpiresInSeconds() - 1L));
            }
            Compute.Builder builder = new Compute.Builder(this.getGceHttpTransport(), this.gceJsonFactory, null).setApplicationName("Elasticsearch/GceCloud/1.0").setRootUrl((String)GCE_ROOT_URL.get(this.settings));
            if (RETRY_SETTING.exists(this.settings)) {
                TimeValue maxWait = (TimeValue)MAX_WAIT_SETTING.get(this.settings);
                RetryHttpInitializerWrapper retryHttpInitializerWrapper = maxWait.getMillis() > 0L ? new RetryHttpInitializerWrapper((Credential)credential, maxWait) : new RetryHttpInitializerWrapper((Credential)credential);
                builder.setHttpRequestInitializer((HttpRequestInitializer)retryHttpInitializerWrapper);
            } else {
                builder.setHttpRequestInitializer((HttpRequestInitializer)credential);
            }
            this.client = builder.build();
        }
        catch (Exception e) {
            this.logger.warn("unable to start GCE discovery service", (Throwable)e);
            throw new IllegalArgumentException("unable to start GCE discovery service", e);
        }
        return this.client;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
        if (this.gceHttpTransport != null) {
            try {
                this.gceHttpTransport.shutdown();
            }
            catch (IOException e) {
                this.logger.warn("unable to shutdown GCE Http Transport", (Throwable)e);
            }
            this.gceHttpTransport = null;
        }
    }

    protected void doClose() throws ElasticsearchException {
    }
}

