/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.env.Environment;

class FileBasedUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    static final String UNICAST_HOSTS_FILE = "unicast_hosts.txt";
    private final Path unicastHostsFilePath;

    FileBasedUnicastHostsProvider(Environment environment) {
        super(environment.settings());
        this.unicastHostsFilePath = environment.configFile().resolve("discovery-file").resolve(UNICAST_HOSTS_FILE);
    }

    public List<TransportAddress> buildDynamicHosts(UnicastHostsProvider.HostsResolver hostsResolver) {
        List hostsList;
        try (Stream<String> lines = Files.lines(this.unicastHostsFilePath);){
            hostsList = lines.filter(line -> !line.startsWith("#")).collect(Collectors.toList());
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Failed to find unicast hosts file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
            hostsList = Collections.emptyList();
        }
        catch (IOException e) {
            this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Error reading unicast hosts file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
            hostsList = Collections.emptyList();
        }
        List dynamicHosts = hostsResolver.resolveHosts(hostsList, 1);
        this.logger.debug("[discovery-file] Using dynamic discovery nodes {}", (Object)dynamicHosts);
        return dynamicHosts;
    }
}

