/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.file;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.file.FileBasedUnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.TransportService;

public class FileBasedDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin {
    private final Settings settings;
    private final Path configPath;

    public FileBasedDiscoveryPlugin(Settings settings, Path configPath) {
        this.settings = settings;
        this.configPath = configPath;
    }

    public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap("file", () -> new FileBasedUnicastHostsProvider(new Environment(this.settings, this.configPath)));
    }
}

