/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.file;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.file.FileBasedUnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastZenPing;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class FileBasedDiscoveryPlugin
extends Plugin
implements DiscoveryPlugin {
    private static final Logger logger = Loggers.getLogger(FileBasedDiscoveryPlugin.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private final Settings settings;
    private ExecutorService fileBasedDiscoveryExecutorService;

    public FileBasedDiscoveryPlugin(Settings settings) {
        this.settings = settings;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, SearchRequestParsers searchRequestParsers, NamedXContentRegistry xContentRegistry) {
        int concurrentConnects = (Integer)UnicastZenPing.DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING.get(this.settings);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"[file_based_discovery_resolve]");
        this.fileBasedDiscoveryExecutorService = EsExecutors.newScaling((String)"file_based_discovery_resolve", (int)0, (int)concurrentConnects, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)threadFactory, (ThreadContext)threadPool.getThreadContext());
        return Collections.emptyList();
    }

    public void close() throws IOException {
        ThreadPool.terminate((ExecutorService)this.fileBasedDiscoveryExecutorService, (long)0L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap("file", () -> new FileBasedUnicastHostsProvider(this.settings, transportService, this.fileBasedDiscoveryExecutorService));
    }

    public Settings additionalSettings() {
        String discoveryType = (String)DiscoveryModule.DISCOVERY_TYPE_SETTING.get(this.settings);
        if (discoveryType.equals("zen")) {
            deprecationLogger.deprecated("Using " + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + " setting to set hosts provider is deprecated. Set \"" + DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey() + ": file\" instead", new Object[0]);
            if (!DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.exists(this.settings)) {
                return Settings.builder().put(DiscoveryModule.DISCOVERY_HOSTS_PROVIDER_SETTING.getKey(), "file").build();
            }
        }
        return Settings.EMPTY;
    }
}

