/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastZenPing;
import org.elasticsearch.env.Environment;
import org.elasticsearch.transport.TransportService;

class FileBasedUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    static final String UNICAST_HOSTS_FILE = "unicast_hosts.txt";
    static final String UNICAST_HOST_PREFIX = "#zen_file_unicast_host_";
    private final TransportService transportService;
    private final ExecutorService executorService;
    private final Path unicastHostsFilePath;
    private final AtomicLong nodeIdGenerator = new AtomicLong();
    private final TimeValue resolveTimeout;

    FileBasedUnicastHostsProvider(Settings settings, TransportService transportService, ExecutorService executorService) {
        super(settings);
        this.transportService = transportService;
        this.executorService = executorService;
        this.unicastHostsFilePath = new Environment(settings).configFile().resolve("discovery-file").resolve(UNICAST_HOSTS_FILE);
        this.resolveTimeout = (TimeValue)UnicastZenPing.DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT.get(settings);
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        List hostsList;
        try (Stream<String> lines = Files.lines(this.unicastHostsFilePath);){
            hostsList = lines.filter(line -> !line.startsWith("#")).collect(Collectors.toList());
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Failed to find unicast hosts file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
            hostsList = Collections.emptyList();
        }
        catch (IOException e) {
            this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Error reading unicast hosts file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
            hostsList = Collections.emptyList();
        }
        ArrayList<DiscoveryNode> discoNodes = new ArrayList<DiscoveryNode>();
        try {
            discoNodes.addAll(UnicastZenPing.resolveDiscoveryNodes((ExecutorService)this.executorService, (Logger)this.logger, hostsList, (int)1, (TransportService)this.transportService, () -> UNICAST_HOST_PREFIX + this.nodeIdGenerator.incrementAndGet() + "#", (TimeValue)this.resolveTimeout));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.logger.debug("[discovery-file] Using dynamic discovery nodes {}", discoNodes);
        return discoNodes;
    }
}

