/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.env.Environment;
import org.elasticsearch.transport.TransportService;

public class FileBasedUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    static final String UNICAST_HOSTS_FILE = "unicast_hosts.txt";
    static final String UNICAST_HOST_PREFIX = "#zen_file_unicast_host_";
    private final TransportService transportService;
    private final Path unicastHostsFilePath;
    private final AtomicLong nodeIdGenerator = new AtomicLong();

    @Inject
    public FileBasedUnicastHostsProvider(Settings settings, TransportService transportService) {
        super(settings);
        this.transportService = transportService;
        this.unicastHostsFilePath = new Environment(settings).configFile().resolve("discovery-file").resolve(UNICAST_HOSTS_FILE);
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        List<String> hostsList;
        try {
            Stream<String> lines = Files.lines(this.unicastHostsFilePath);
            Object object = null;
            try {
                hostsList = lines.filter(line -> !line.startsWith("#")).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (lines != null) {
                    if (object != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        lines.close();
                    }
                }
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Failed to find unicast hosts file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
            hostsList = Collections.emptyList();
        }
        catch (IOException e) {
            this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Error reading unicast hosts file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
            hostsList = Collections.emptyList();
        }
        ArrayList<DiscoveryNode> discoNodes = new ArrayList<DiscoveryNode>();
        for (String host : hostsList) {
            try {
                discoNodes.addAll(UnicastZenPing.resolveDiscoveryNodes((String)host, (int)1, (TransportService)this.transportService, () -> UNICAST_HOST_PREFIX + this.nodeIdGenerator.incrementAndGet() + "#"));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn(() -> new ParameterizedMessage("[discovery-file] Failed to parse transport address from [{}]", (Object)host), (Throwable)e);
            }
        }
        this.logger.debug("[discovery-file] Using dynamic discovery nodes {}", discoNodes);
        return discoNodes;
    }
}

