/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScope;

public class DescribeNetworkInsightsAccessScopesIterable
implements SdkIterable<DescribeNetworkInsightsAccessScopesResponse> {
    private final Ec2Client client;
    private final DescribeNetworkInsightsAccessScopesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNetworkInsightsAccessScopesIterable(Ec2Client client, DescribeNetworkInsightsAccessScopesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNetworkInsightsAccessScopesResponseFetcher();
    }

    public Iterator<DescribeNetworkInsightsAccessScopesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkInsightsAccessScope> networkInsightsAccessScopes() {
        Function<DescribeNetworkInsightsAccessScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInsightsAccessScopes() != null) {
                return response.networkInsightsAccessScopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNetworkInsightsAccessScopesResponseFetcher
    implements SyncPageFetcher<DescribeNetworkInsightsAccessScopesResponse> {
        private DescribeNetworkInsightsAccessScopesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInsightsAccessScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNetworkInsightsAccessScopesResponse nextPage(DescribeNetworkInsightsAccessScopesResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInsightsAccessScopesIterable.this.client.describeNetworkInsightsAccessScopes(DescribeNetworkInsightsAccessScopesIterable.this.firstRequest);
            }
            return DescribeNetworkInsightsAccessScopesIterable.this.client.describeNetworkInsightsAccessScopes((DescribeNetworkInsightsAccessScopesRequest)((Object)DescribeNetworkInsightsAccessScopesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

