/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.PrefixList;

public class DescribePrefixListsIterable
implements SdkIterable<DescribePrefixListsResponse> {
    private final Ec2Client client;
    private final DescribePrefixListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePrefixListsIterable(Ec2Client client, DescribePrefixListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePrefixListsResponseFetcher();
    }

    public Iterator<DescribePrefixListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrefixList> prefixLists() {
        Function<DescribePrefixListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.prefixLists() != null) {
                return response.prefixLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePrefixListsResponseFetcher
    implements SyncPageFetcher<DescribePrefixListsResponse> {
        private DescribePrefixListsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePrefixListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePrefixListsResponse nextPage(DescribePrefixListsResponse previousPage) {
            if (previousPage == null) {
                return DescribePrefixListsIterable.this.client.describePrefixLists(DescribePrefixListsIterable.this.firstRequest);
            }
            return DescribePrefixListsIterable.this.client.describePrefixLists((DescribePrefixListsRequest)((Object)DescribePrefixListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

