/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;

public class DescribeNetworkAclsPublisher
implements SdkPublisher<DescribeNetworkAclsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNetworkAclsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNetworkAclsPublisher(Ec2AsyncClient client, DescribeNetworkAclsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNetworkAclsPublisher(Ec2AsyncClient client, DescribeNetworkAclsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNetworkAclsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNetworkAclsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkAcl> networkAcls() {
        Function<DescribeNetworkAclsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkAcls() != null) {
                return response.networkAcls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNetworkAclsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNetworkAclsResponseFetcher
    implements AsyncPageFetcher<DescribeNetworkAclsResponse> {
        private DescribeNetworkAclsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkAclsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNetworkAclsResponse> nextPage(DescribeNetworkAclsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkAclsPublisher.this.client.describeNetworkAcls(DescribeNetworkAclsPublisher.this.firstRequest);
            }
            return DescribeNetworkAclsPublisher.this.client.describeNetworkAcls((DescribeNetworkAclsRequest)((Object)DescribeNetworkAclsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

