/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BatchState {
    SUBMITTED("submitted"),
    ACTIVE("active"),
    CANCELLED("cancelled"),
    FAILED("failed"),
    CANCELLED_RUNNING("cancelled_running"),
    CANCELLED_TERMINATING("cancelled_terminating"),
    MODIFYING("modifying"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BatchState> VALUE_MAP;
    private final String value;

    private BatchState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BatchState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BatchState> knownValues() {
        EnumSet<BatchState> knownValues = EnumSet.allOf(BatchState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BatchState.class, BatchState::toString);
    }
}

