/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import java.time.Duration;
import org.elasticsearch.common.Strings;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.imds.Ec2MetadataClient;

class AwsEc2Utils {
    private static final Duration IMDS_CONNECTION_TIMEOUT = Duration.ofSeconds(2L);

    AwsEc2Utils() {
    }

    static String getInstanceMetadata(String metadataPath) {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        httpClientBuilder.connectionTimeout(IMDS_CONNECTION_TIMEOUT);
        try (Ec2MetadataClient ec2Client = (Ec2MetadataClient)Ec2MetadataClient.builder().httpClient((SdkHttpClient.Builder)httpClientBuilder).build();){
            String metadataValue = ec2Client.get(metadataPath).asString();
            if (!Strings.hasText((String)metadataValue)) {
                throw new IllegalStateException("no ec2 metadata returned from " + metadataPath);
            }
            String string = metadataValue;
            return string;
        }
    }
}

