/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateSubnetRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateSubnetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateSubnetRequest> {
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String availabilityZone;
    private String availabilityZoneId;
    private String cidrBlock;
    private String ipv6CidrBlock;
    private String outpostArn;
    private String vpcId;
    private Boolean ipv6Native;
    private String ipv4IpamPoolId;
    private Integer ipv4NetmaskLength;
    private String ipv6IpamPoolId;
    private Integer ipv6NetmaskLength;

    public CreateSubnetRequest() {
    }

    public CreateSubnetRequest(String vpcId, String cidrBlock) {
        this.setVpcId(vpcId);
        this.setCidrBlock(cidrBlock);
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateSubnetRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateSubnetRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateSubnetRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setAvailabilityZoneId(String availabilityZoneId) {
        this.availabilityZoneId = availabilityZoneId;
    }

    public String getAvailabilityZoneId() {
        return this.availabilityZoneId;
    }

    public CreateSubnetRequest withAvailabilityZoneId(String availabilityZoneId) {
        this.setAvailabilityZoneId(availabilityZoneId);
        return this;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public CreateSubnetRequest withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setIpv6CidrBlock(String ipv6CidrBlock) {
        this.ipv6CidrBlock = ipv6CidrBlock;
    }

    public String getIpv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public CreateSubnetRequest withIpv6CidrBlock(String ipv6CidrBlock) {
        this.setIpv6CidrBlock(ipv6CidrBlock);
        return this;
    }

    public void setOutpostArn(String outpostArn) {
        this.outpostArn = outpostArn;
    }

    public String getOutpostArn() {
        return this.outpostArn;
    }

    public CreateSubnetRequest withOutpostArn(String outpostArn) {
        this.setOutpostArn(outpostArn);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public CreateSubnetRequest withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setIpv6Native(Boolean ipv6Native) {
        this.ipv6Native = ipv6Native;
    }

    public Boolean getIpv6Native() {
        return this.ipv6Native;
    }

    public CreateSubnetRequest withIpv6Native(Boolean ipv6Native) {
        this.setIpv6Native(ipv6Native);
        return this;
    }

    public Boolean isIpv6Native() {
        return this.ipv6Native;
    }

    public void setIpv4IpamPoolId(String ipv4IpamPoolId) {
        this.ipv4IpamPoolId = ipv4IpamPoolId;
    }

    public String getIpv4IpamPoolId() {
        return this.ipv4IpamPoolId;
    }

    public CreateSubnetRequest withIpv4IpamPoolId(String ipv4IpamPoolId) {
        this.setIpv4IpamPoolId(ipv4IpamPoolId);
        return this;
    }

    public void setIpv4NetmaskLength(Integer ipv4NetmaskLength) {
        this.ipv4NetmaskLength = ipv4NetmaskLength;
    }

    public Integer getIpv4NetmaskLength() {
        return this.ipv4NetmaskLength;
    }

    public CreateSubnetRequest withIpv4NetmaskLength(Integer ipv4NetmaskLength) {
        this.setIpv4NetmaskLength(ipv4NetmaskLength);
        return this;
    }

    public void setIpv6IpamPoolId(String ipv6IpamPoolId) {
        this.ipv6IpamPoolId = ipv6IpamPoolId;
    }

    public String getIpv6IpamPoolId() {
        return this.ipv6IpamPoolId;
    }

    public CreateSubnetRequest withIpv6IpamPoolId(String ipv6IpamPoolId) {
        this.setIpv6IpamPoolId(ipv6IpamPoolId);
        return this;
    }

    public void setIpv6NetmaskLength(Integer ipv6NetmaskLength) {
        this.ipv6NetmaskLength = ipv6NetmaskLength;
    }

    public Integer getIpv6NetmaskLength() {
        return this.ipv6NetmaskLength;
    }

    public CreateSubnetRequest withIpv6NetmaskLength(Integer ipv6NetmaskLength) {
        this.setIpv6NetmaskLength(ipv6NetmaskLength);
        return this;
    }

    @Override
    public Request<CreateSubnetRequest> getDryRunRequest() {
        Request<CreateSubnetRequest> request = new CreateSubnetRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getAvailabilityZoneId() != null) {
            sb.append("AvailabilityZoneId: ").append(this.getAvailabilityZoneId()).append(",");
        }
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.getCidrBlock()).append(",");
        }
        if (this.getIpv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(this.getIpv6CidrBlock()).append(",");
        }
        if (this.getOutpostArn() != null) {
            sb.append("OutpostArn: ").append(this.getOutpostArn()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getIpv6Native() != null) {
            sb.append("Ipv6Native: ").append(this.getIpv6Native()).append(",");
        }
        if (this.getIpv4IpamPoolId() != null) {
            sb.append("Ipv4IpamPoolId: ").append(this.getIpv4IpamPoolId()).append(",");
        }
        if (this.getIpv4NetmaskLength() != null) {
            sb.append("Ipv4NetmaskLength: ").append(this.getIpv4NetmaskLength()).append(",");
        }
        if (this.getIpv6IpamPoolId() != null) {
            sb.append("Ipv6IpamPoolId: ").append(this.getIpv6IpamPoolId()).append(",");
        }
        if (this.getIpv6NetmaskLength() != null) {
            sb.append("Ipv6NetmaskLength: ").append(this.getIpv6NetmaskLength());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest)obj;
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getAvailabilityZoneId() == null ^ this.getAvailabilityZoneId() == null) {
            return false;
        }
        if (other.getAvailabilityZoneId() != null && !other.getAvailabilityZoneId().equals(this.getAvailabilityZoneId())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getIpv6CidrBlock() == null ^ this.getIpv6CidrBlock() == null) {
            return false;
        }
        if (other.getIpv6CidrBlock() != null && !other.getIpv6CidrBlock().equals(this.getIpv6CidrBlock())) {
            return false;
        }
        if (other.getOutpostArn() == null ^ this.getOutpostArn() == null) {
            return false;
        }
        if (other.getOutpostArn() != null && !other.getOutpostArn().equals(this.getOutpostArn())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getIpv6Native() == null ^ this.getIpv6Native() == null) {
            return false;
        }
        if (other.getIpv6Native() != null && !other.getIpv6Native().equals(this.getIpv6Native())) {
            return false;
        }
        if (other.getIpv4IpamPoolId() == null ^ this.getIpv4IpamPoolId() == null) {
            return false;
        }
        if (other.getIpv4IpamPoolId() != null && !other.getIpv4IpamPoolId().equals(this.getIpv4IpamPoolId())) {
            return false;
        }
        if (other.getIpv4NetmaskLength() == null ^ this.getIpv4NetmaskLength() == null) {
            return false;
        }
        if (other.getIpv4NetmaskLength() != null && !other.getIpv4NetmaskLength().equals(this.getIpv4NetmaskLength())) {
            return false;
        }
        if (other.getIpv6IpamPoolId() == null ^ this.getIpv6IpamPoolId() == null) {
            return false;
        }
        if (other.getIpv6IpamPoolId() != null && !other.getIpv6IpamPoolId().equals(this.getIpv6IpamPoolId())) {
            return false;
        }
        if (other.getIpv6NetmaskLength() == null ^ this.getIpv6NetmaskLength() == null) {
            return false;
        }
        return other.getIpv6NetmaskLength() == null || other.getIpv6NetmaskLength().equals(this.getIpv6NetmaskLength());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneId() == null ? 0 : this.getAvailabilityZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6CidrBlock() == null ? 0 : this.getIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostArn() == null ? 0 : this.getOutpostArn().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Native() == null ? 0 : this.getIpv6Native().hashCode());
        hashCode = 31 * hashCode + (this.getIpv4IpamPoolId() == null ? 0 : this.getIpv4IpamPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIpv4NetmaskLength() == null ? 0 : this.getIpv4NetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6IpamPoolId() == null ? 0 : this.getIpv6IpamPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6NetmaskLength() == null ? 0 : this.getIpv6NetmaskLength().hashCode());
        return hashCode;
    }

    public CreateSubnetRequest clone() {
        return (CreateSubnetRequest)super.clone();
    }
}

