/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessTrustProviderRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessTrustProviderRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessTrustProviderRequest>, CreateVerifiedAccessTrustProviderRequest> {
    public Request<CreateVerifiedAccessTrustProviderRequest> marshall(CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest) {
        SdkInternalList createVerifiedAccessTrustProviderRequestTagSpecificationsList;
        CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions;
        CreateVerifiedAccessTrustProviderOidcOptions oidcOptions;
        if (createVerifiedAccessTrustProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVerifiedAccessTrustProviderRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessTrustProvider");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessTrustProviderRequest.getTrustProviderType() != null) {
            request.addParameter("TrustProviderType", StringUtils.fromString((String)createVerifiedAccessTrustProviderRequest.getTrustProviderType()));
        }
        if (createVerifiedAccessTrustProviderRequest.getUserTrustProviderType() != null) {
            request.addParameter("UserTrustProviderType", StringUtils.fromString((String)createVerifiedAccessTrustProviderRequest.getUserTrustProviderType()));
        }
        if (createVerifiedAccessTrustProviderRequest.getDeviceTrustProviderType() != null) {
            request.addParameter("DeviceTrustProviderType", StringUtils.fromString((String)createVerifiedAccessTrustProviderRequest.getDeviceTrustProviderType()));
        }
        if ((oidcOptions = createVerifiedAccessTrustProviderRequest.getOidcOptions()) != null) {
            if (oidcOptions.getIssuer() != null) {
                request.addParameter("OidcOptions.Issuer", StringUtils.fromString((String)oidcOptions.getIssuer()));
            }
            if (oidcOptions.getAuthorizationEndpoint() != null) {
                request.addParameter("OidcOptions.AuthorizationEndpoint", StringUtils.fromString((String)oidcOptions.getAuthorizationEndpoint()));
            }
            if (oidcOptions.getTokenEndpoint() != null) {
                request.addParameter("OidcOptions.TokenEndpoint", StringUtils.fromString((String)oidcOptions.getTokenEndpoint()));
            }
            if (oidcOptions.getUserInfoEndpoint() != null) {
                request.addParameter("OidcOptions.UserInfoEndpoint", StringUtils.fromString((String)oidcOptions.getUserInfoEndpoint()));
            }
            if (oidcOptions.getClientId() != null) {
                request.addParameter("OidcOptions.ClientId", StringUtils.fromString((String)oidcOptions.getClientId()));
            }
            if (oidcOptions.getClientSecret() != null) {
                request.addParameter("OidcOptions.ClientSecret", StringUtils.fromString((String)oidcOptions.getClientSecret()));
            }
            if (oidcOptions.getScope() != null) {
                request.addParameter("OidcOptions.Scope", StringUtils.fromString((String)oidcOptions.getScope()));
            }
        }
        if ((deviceOptions = createVerifiedAccessTrustProviderRequest.getDeviceOptions()) != null) {
            if (deviceOptions.getTenantId() != null) {
                request.addParameter("DeviceOptions.TenantId", StringUtils.fromString((String)deviceOptions.getTenantId()));
            }
            if (deviceOptions.getPublicSigningKeyUrl() != null) {
                request.addParameter("DeviceOptions.PublicSigningKeyUrl", StringUtils.fromString((String)deviceOptions.getPublicSigningKeyUrl()));
            }
        }
        if (createVerifiedAccessTrustProviderRequest.getPolicyReferenceName() != null) {
            request.addParameter("PolicyReferenceName", StringUtils.fromString((String)createVerifiedAccessTrustProviderRequest.getPolicyReferenceName()));
        }
        if (createVerifiedAccessTrustProviderRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createVerifiedAccessTrustProviderRequest.getDescription()));
        }
        if (!(createVerifiedAccessTrustProviderRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessTrustProviderRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessTrustProviderRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessTrustProviderRequestTagSpecificationsListValue : createVerifiedAccessTrustProviderRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessTrustProviderRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVerifiedAccessTrustProviderRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessTrustProviderRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createVerifiedAccessTrustProviderRequest.getClientToken()));
        VerifiedAccessSseSpecificationRequest sseSpecification = createVerifiedAccessTrustProviderRequest.getSseSpecification();
        if (sseSpecification != null) {
            if (sseSpecification.getCustomerManagedKeyEnabled() != null) {
                request.addParameter("SseSpecification.CustomerManagedKeyEnabled", StringUtils.fromBoolean((Boolean)sseSpecification.getCustomerManagedKeyEnabled()));
            }
            if (sseSpecification.getKmsKeyArn() != null) {
                request.addParameter("SseSpecification.KmsKeyArn", StringUtils.fromString((String)sseSpecification.getKmsKeyArn()));
            }
        }
        return request;
    }
}

