/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.util.EC2MetadataUtils;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.ec2.AwsEc2SeedHostsProvider;
import org.elasticsearch.discovery.ec2.AwsEc2Service;
import org.elasticsearch.discovery.ec2.AwsEc2ServiceImpl;
import org.elasticsearch.discovery.ec2.AwsEc2Utils;
import org.elasticsearch.discovery.ec2.Ec2ClientSettings;
import org.elasticsearch.discovery.ec2.Ec2NameResolver;
import org.elasticsearch.discovery.ec2.SocketAccess;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.transport.TransportService;

public class Ec2DiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
ReloadablePlugin {
    private static final Logger logger = LogManager.getLogger(Ec2DiscoveryPlugin.class);
    public static final String EC2 = "ec2";
    private final Settings settings;
    protected final AwsEc2Service ec2Service;

    public Ec2DiscoveryPlugin(Settings settings) {
        this(settings, new AwsEc2ServiceImpl());
    }

    protected Ec2DiscoveryPlugin(Settings settings, AwsEc2ServiceImpl ec2Service) {
        this.settings = settings;
        this.ec2Service = ec2Service;
        this.reload(settings);
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings _settings) {
        logger.debug("Register _ec2_, _ec2:xxx_ network names");
        return new Ec2NameResolver();
    }

    public Map<String, Supplier<SeedHostsProvider>> getSeedHostProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(EC2, () -> new AwsEc2SeedHostsProvider(this.settings, transportService, this.ec2Service));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Ec2ClientSettings.ACCESS_KEY_SETTING, Ec2ClientSettings.SECRET_KEY_SETTING, Ec2ClientSettings.SESSION_TOKEN_SETTING, Ec2ClientSettings.ENDPOINT_SETTING, Ec2ClientSettings.PROTOCOL_SETTING, Ec2ClientSettings.PROXY_HOST_SETTING, Ec2ClientSettings.PROXY_PORT_SETTING, Ec2ClientSettings.PROXY_USERNAME_SETTING, Ec2ClientSettings.PROXY_PASSWORD_SETTING, Ec2ClientSettings.READ_TIMEOUT_SETTING, AwsEc2Service.HOST_TYPE_SETTING, AwsEc2Service.ANY_GROUP_SETTING, AwsEc2Service.GROUPS_SETTING, AwsEc2Service.AVAILABILITY_ZONES_SETTING, AwsEc2Service.NODE_CACHE_TIME_SETTING, AwsEc2Service.TAG_SETTING, AwsEc2Service.AUTO_ATTRIBUTE_SETTING);
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        String azMetadataUrl = EC2MetadataUtils.getHostAddressForEC2MetadataService() + "/latest/meta-data/placement/availability-zone";
        String azMetadataTokenUrl = EC2MetadataUtils.getHostAddressForEC2MetadataService() + "/latest/api/token";
        builder.put(Ec2DiscoveryPlugin.getAvailabilityZoneNodeAttributes(this.settings, azMetadataUrl, azMetadataTokenUrl));
        return builder.build();
    }

    @SuppressForbidden(reason="We call getInputStream in doPrivileged and provide SocketPermission")
    static Settings getAvailabilityZoneNodeAttributes(Settings settings, String azMetadataUrl, String azMetadataTokenUrl) {
        URLConnection urlConnection;
        URL url;
        if (!((Boolean)AwsEc2Service.AUTO_ATTRIBUTE_SETTING.get(settings)).booleanValue()) {
            return Settings.EMPTY;
        }
        Settings.Builder attrs = Settings.builder();
        try {
            url = new URL(azMetadataUrl);
            logger.debug("obtaining ec2 [placement/availability-zone] from ec2 meta-data url {}", (Object)url);
            urlConnection = SocketAccess.doPrivilegedIOException(url::openConnection);
            urlConnection.setConnectTimeout(2000);
            AwsEc2Utils.getMetadataToken(azMetadataTokenUrl).ifPresent(token -> urlConnection.setRequestProperty("X-aws-ec2-metadata-token", (String)token));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (InputStream in = SocketAccess.doPrivilegedIOException(urlConnection::getInputStream);
             BufferedReader urlReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String metadataResult = urlReader.readLine();
            if (metadataResult == null || metadataResult.length() == 0) {
                throw new IllegalStateException("no ec2 metadata returned from " + url);
            }
            attrs.put(Node.NODE_ATTRIBUTES.getKey() + "aws_availability_zone", metadataResult);
        }
        catch (IOException e) {
            logger.error("failed to get metadata for [placement/availability-zone]", (Throwable)e);
        }
        return attrs.build();
    }

    public void close() throws IOException {
        this.ec2Service.close();
    }

    public void reload(Settings settingsToLoad) {
        Ec2ClientSettings clientSettings = Ec2ClientSettings.getClientSettings(settingsToLoad);
        this.ec2Service.refreshAndClearCache(clientSettings);
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            try {
                Jackson.jsonNodeOf((String)"{}");
                Class.forName("com.amazonaws.ClientConfiguration");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

