/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserTrustProviderType {
    IAM_IDENTITY_CENTER("iam-identity-center"),
    OIDC("oidc"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserTrustProviderType> VALUE_MAP;
    private final String value;

    private UserTrustProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserTrustProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserTrustProviderType> knownValues() {
        EnumSet<UserTrustProviderType> knownValues = EnumSet.allOf(UserTrustProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserTrustProviderType.class, UserTrustProviderType::toString);
    }
}

