/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.FleetSpotMaintenanceStrategies;
import com.amazonaws.services.ec2.model.SpotAllocationStrategy;
import com.amazonaws.services.ec2.model.SpotInstanceInterruptionBehavior;
import java.io.Serializable;

public class SpotOptions
implements Serializable,
Cloneable {
    private String allocationStrategy;
    private FleetSpotMaintenanceStrategies maintenanceStrategies;
    private String instanceInterruptionBehavior;
    private Integer instancePoolsToUseCount;
    private Boolean singleInstanceType;
    private Boolean singleAvailabilityZone;
    private Integer minTargetCapacity;
    private String maxTotalPrice;

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public SpotOptions withAllocationStrategy(String allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public SpotOptions withAllocationStrategy(SpotAllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
        return this;
    }

    public void setMaintenanceStrategies(FleetSpotMaintenanceStrategies maintenanceStrategies) {
        this.maintenanceStrategies = maintenanceStrategies;
    }

    public FleetSpotMaintenanceStrategies getMaintenanceStrategies() {
        return this.maintenanceStrategies;
    }

    public SpotOptions withMaintenanceStrategies(FleetSpotMaintenanceStrategies maintenanceStrategies) {
        this.setMaintenanceStrategies(maintenanceStrategies);
        return this;
    }

    public void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
        this.instanceInterruptionBehavior = instanceInterruptionBehavior;
    }

    public String getInstanceInterruptionBehavior() {
        return this.instanceInterruptionBehavior;
    }

    public SpotOptions withInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
        this.setInstanceInterruptionBehavior(instanceInterruptionBehavior);
        return this;
    }

    public SpotOptions withInstanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior) {
        this.instanceInterruptionBehavior = instanceInterruptionBehavior.toString();
        return this;
    }

    public void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
        this.instancePoolsToUseCount = instancePoolsToUseCount;
    }

    public Integer getInstancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public SpotOptions withInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
        this.setInstancePoolsToUseCount(instancePoolsToUseCount);
        return this;
    }

    public void setSingleInstanceType(Boolean singleInstanceType) {
        this.singleInstanceType = singleInstanceType;
    }

    public Boolean getSingleInstanceType() {
        return this.singleInstanceType;
    }

    public SpotOptions withSingleInstanceType(Boolean singleInstanceType) {
        this.setSingleInstanceType(singleInstanceType);
        return this;
    }

    public Boolean isSingleInstanceType() {
        return this.singleInstanceType;
    }

    public void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
        this.singleAvailabilityZone = singleAvailabilityZone;
    }

    public Boolean getSingleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public SpotOptions withSingleAvailabilityZone(Boolean singleAvailabilityZone) {
        this.setSingleAvailabilityZone(singleAvailabilityZone);
        return this;
    }

    public Boolean isSingleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public void setMinTargetCapacity(Integer minTargetCapacity) {
        this.minTargetCapacity = minTargetCapacity;
    }

    public Integer getMinTargetCapacity() {
        return this.minTargetCapacity;
    }

    public SpotOptions withMinTargetCapacity(Integer minTargetCapacity) {
        this.setMinTargetCapacity(minTargetCapacity);
        return this;
    }

    public void setMaxTotalPrice(String maxTotalPrice) {
        this.maxTotalPrice = maxTotalPrice;
    }

    public String getMaxTotalPrice() {
        return this.maxTotalPrice;
    }

    public SpotOptions withMaxTotalPrice(String maxTotalPrice) {
        this.setMaxTotalPrice(maxTotalPrice);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.getAllocationStrategy()).append(",");
        }
        if (this.getMaintenanceStrategies() != null) {
            sb.append("MaintenanceStrategies: ").append(this.getMaintenanceStrategies()).append(",");
        }
        if (this.getInstanceInterruptionBehavior() != null) {
            sb.append("InstanceInterruptionBehavior: ").append(this.getInstanceInterruptionBehavior()).append(",");
        }
        if (this.getInstancePoolsToUseCount() != null) {
            sb.append("InstancePoolsToUseCount: ").append(this.getInstancePoolsToUseCount()).append(",");
        }
        if (this.getSingleInstanceType() != null) {
            sb.append("SingleInstanceType: ").append(this.getSingleInstanceType()).append(",");
        }
        if (this.getSingleAvailabilityZone() != null) {
            sb.append("SingleAvailabilityZone: ").append(this.getSingleAvailabilityZone()).append(",");
        }
        if (this.getMinTargetCapacity() != null) {
            sb.append("MinTargetCapacity: ").append(this.getMinTargetCapacity()).append(",");
        }
        if (this.getMaxTotalPrice() != null) {
            sb.append("MaxTotalPrice: ").append(this.getMaxTotalPrice());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptions)) {
            return false;
        }
        SpotOptions other = (SpotOptions)obj;
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        if (other.getAllocationStrategy() != null && !other.getAllocationStrategy().equals(this.getAllocationStrategy())) {
            return false;
        }
        if (other.getMaintenanceStrategies() == null ^ this.getMaintenanceStrategies() == null) {
            return false;
        }
        if (other.getMaintenanceStrategies() != null && !other.getMaintenanceStrategies().equals(this.getMaintenanceStrategies())) {
            return false;
        }
        if (other.getInstanceInterruptionBehavior() == null ^ this.getInstanceInterruptionBehavior() == null) {
            return false;
        }
        if (other.getInstanceInterruptionBehavior() != null && !other.getInstanceInterruptionBehavior().equals(this.getInstanceInterruptionBehavior())) {
            return false;
        }
        if (other.getInstancePoolsToUseCount() == null ^ this.getInstancePoolsToUseCount() == null) {
            return false;
        }
        if (other.getInstancePoolsToUseCount() != null && !other.getInstancePoolsToUseCount().equals(this.getInstancePoolsToUseCount())) {
            return false;
        }
        if (other.getSingleInstanceType() == null ^ this.getSingleInstanceType() == null) {
            return false;
        }
        if (other.getSingleInstanceType() != null && !other.getSingleInstanceType().equals(this.getSingleInstanceType())) {
            return false;
        }
        if (other.getSingleAvailabilityZone() == null ^ this.getSingleAvailabilityZone() == null) {
            return false;
        }
        if (other.getSingleAvailabilityZone() != null && !other.getSingleAvailabilityZone().equals(this.getSingleAvailabilityZone())) {
            return false;
        }
        if (other.getMinTargetCapacity() == null ^ this.getMinTargetCapacity() == null) {
            return false;
        }
        if (other.getMinTargetCapacity() != null && !other.getMinTargetCapacity().equals(this.getMinTargetCapacity())) {
            return false;
        }
        if (other.getMaxTotalPrice() == null ^ this.getMaxTotalPrice() == null) {
            return false;
        }
        return other.getMaxTotalPrice() == null || other.getMaxTotalPrice().equals(this.getMaxTotalPrice());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceStrategies() == null ? 0 : this.getMaintenanceStrategies().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInterruptionBehavior() == null ? 0 : this.getInstanceInterruptionBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getInstancePoolsToUseCount() == null ? 0 : this.getInstancePoolsToUseCount().hashCode());
        hashCode = 31 * hashCode + (this.getSingleInstanceType() == null ? 0 : this.getSingleInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getSingleAvailabilityZone() == null ? 0 : this.getSingleAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getMinTargetCapacity() == null ? 0 : this.getMinTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaxTotalPrice() == null ? 0 : this.getMaxTotalPrice().hashCode());
        return hashCode;
    }

    public SpotOptions clone() {
        try {
            return (SpotOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

