/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceTypeOfferingsRequestMarshaller
implements Marshaller<Request<DescribeInstanceTypeOfferingsRequest>, DescribeInstanceTypeOfferingsRequest> {
    public Request<DescribeInstanceTypeOfferingsRequest> marshall(DescribeInstanceTypeOfferingsRequest describeInstanceTypeOfferingsRequest) {
        SdkInternalList describeInstanceTypeOfferingsRequestFiltersList;
        if (describeInstanceTypeOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceTypeOfferingsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceTypeOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceTypeOfferingsRequest.getLocationType() != null) {
            request.addParameter("LocationType", StringUtils.fromString((String)describeInstanceTypeOfferingsRequest.getLocationType()));
        }
        if (!(describeInstanceTypeOfferingsRequestFiltersList = (SdkInternalList)describeInstanceTypeOfferingsRequest.getFilters()).isEmpty() || !describeInstanceTypeOfferingsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceTypeOfferingsRequestFiltersListValue : describeInstanceTypeOfferingsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceTypeOfferingsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInstanceTypeOfferingsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceTypeOfferingsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeInstanceTypeOfferingsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInstanceTypeOfferingsRequest.getMaxResults()));
        }
        if (describeInstanceTypeOfferingsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstanceTypeOfferingsRequest.getNextToken()));
        }
        return request;
    }
}

