/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.discovery.ec2.SocketAccess;

class AwsEc2Utils {
    private static final Logger logger = LogManager.getLogger(AwsEc2Utils.class);
    private static final int TIMEOUT = Optional.ofNullable(System.getenv("AWS_METADATA_SERVICE_TIMEOUT")).filter(StringUtils::hasValue).map(s -> Integer.parseInt(s) * 1000).orElse(2000);
    private static final int METADATA_TOKEN_TTL_SECONDS = 10;
    static final String X_AWS_EC_2_METADATA_TOKEN = "X-aws-ec2-metadata-token";

    AwsEc2Utils() {
    }

    @SuppressForbidden(reason="We call getInputStream in doPrivileged and provide SocketPermission")
    static Optional<String> getMetadataToken(String metadataTokenUrl) {
        if (Strings.isNullOrEmpty((String)metadataTokenUrl)) {
            return Optional.empty();
        }
        return SocketAccess.doPrivileged(() -> {
            HttpURLConnection urlConnection;
            try {
                urlConnection = (HttpURLConnection)new URL(metadataTokenUrl).openConnection();
                urlConnection.setRequestMethod("PUT");
                urlConnection.setConnectTimeout(TIMEOUT);
                urlConnection.setReadTimeout(TIMEOUT);
                urlConnection.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", String.valueOf(10));
            }
            catch (IOException e) {
                logger.warn("Unable to access the IMDSv2 URI: " + metadataTokenUrl, (Throwable)e);
                return Optional.empty();
            }
            try (InputStream in = urlConnection.getInputStream();){
                Optional<String> optional;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    optional = Optional.ofNullable(reader.readLine()).filter(s -> !s.isBlank());
                }
                return optional;
            }
            catch (IOException e) {
                logger.warn("Unable to get a session token from IMDSv2 URI: " + metadataTokenUrl, (Throwable)e);
                return Optional.empty();
            }
        });
    }
}

