/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.FpgaImage;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.FpgaImageStateStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.PciIdStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ProductCodeStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class FpgaImageStaxUnmarshaller
implements Unmarshaller<FpgaImage, StaxUnmarshallerContext> {
    private static FpgaImageStaxUnmarshaller instance;

    public FpgaImage unmarshall(StaxUnmarshallerContext context) throws Exception {
        FpgaImage fpgaImage = new FpgaImage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return fpgaImage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("fpgaImageId", targetDepth)) {
                    fpgaImage.setFpgaImageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("fpgaImageGlobalId", targetDepth)) {
                    fpgaImage.setFpgaImageGlobalId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("name", targetDepth)) {
                    fpgaImage.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    fpgaImage.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("shellVersion", targetDepth)) {
                    fpgaImage.setShellVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("pciId", targetDepth)) {
                    fpgaImage.setPciId(PciIdStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    fpgaImage.setState(FpgaImageStateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createTime", targetDepth)) {
                    fpgaImage.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("updateTime", targetDepth)) {
                    fpgaImage.setUpdateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    fpgaImage.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerAlias", targetDepth)) {
                    fpgaImage.setOwnerAlias(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productCodes", targetDepth)) {
                    fpgaImage.withProductCodes(new ArrayList<ProductCode>());
                    continue;
                }
                if (context.testExpression("productCodes/item", targetDepth)) {
                    fpgaImage.withProductCodes(ProductCodeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tags", targetDepth)) {
                    fpgaImage.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tags/item", targetDepth)) {
                    fpgaImage.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("public", targetDepth)) {
                    fpgaImage.setPublic(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("dataRetentionSupport", targetDepth)) continue;
                fpgaImage.setDataRetentionSupport(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return fpgaImage;
    }

    public static FpgaImageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FpgaImageStaxUnmarshaller();
        }
        return instance;
    }
}

