/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateIpamScopeRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateIpamScopeRequestMarshaller
implements Marshaller<Request<CreateIpamScopeRequest>, CreateIpamScopeRequest> {
    public Request<CreateIpamScopeRequest> marshall(CreateIpamScopeRequest createIpamScopeRequest) {
        SdkInternalList createIpamScopeRequestTagSpecificationsList;
        if (createIpamScopeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIpamScopeRequest, "AmazonEC2");
        request.addParameter("Action", "CreateIpamScope");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createIpamScopeRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString((String)createIpamScopeRequest.getIpamId()));
        }
        if (createIpamScopeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createIpamScopeRequest.getDescription()));
        }
        if (!(createIpamScopeRequestTagSpecificationsList = (SdkInternalList)createIpamScopeRequest.getTagSpecifications()).isEmpty() || !createIpamScopeRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createIpamScopeRequestTagSpecificationsListValue : createIpamScopeRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createIpamScopeRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createIpamScopeRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createIpamScopeRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createIpamScopeRequest.getClientToken()));
        return request;
    }
}

