/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResourceStatementRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> resources;
    private SdkInternalList<String> resourceTypes;

    public List<String> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList(resources);
    }

    public ResourceStatementRequest withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources((Collection<String>)new SdkInternalList(resources.length));
        }
        for (String ele : resources) {
            this.resources.add((Object)ele);
        }
        return this;
    }

    public ResourceStatementRequest withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public List<String> getResourceTypes() {
        if (this.resourceTypes == null) {
            this.resourceTypes = new SdkInternalList();
        }
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new SdkInternalList(resourceTypes);
    }

    public ResourceStatementRequest withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes((Collection<String>)new SdkInternalList(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add((Object)ele);
        }
        return this;
    }

    public ResourceStatementRequest withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatementRequest)) {
            return false;
        }
        ResourceStatementRequest other = (ResourceStatementRequest)obj;
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        return other.getResourceTypes() == null || other.getResourceTypes().equals(this.getResourceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        return hashCode;
    }

    public ResourceStatementRequest clone() {
        try {
            return (ResourceStatementRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

