/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        SdkInternalList modifySnapshotAttributeRequestUserIdsList;
        SdkInternalList modifySnapshotAttributeRequestGroupNamesList;
        CreateVolumePermissionModifications createVolumePermission;
        if (modifySnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifySnapshotAttributeRequest.getAttribute()));
        }
        if ((createVolumePermission = modifySnapshotAttributeRequest.getCreateVolumePermission()) != null) {
            SdkInternalList createVolumePermissionModificationsRemoveList;
            SdkInternalList createVolumePermissionModificationsAddList = (SdkInternalList)createVolumePermission.getAdd();
            if (!createVolumePermissionModificationsAddList.isEmpty() || !createVolumePermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (Object createVolumePermissionModificationsAddListValue : createVolumePermissionModificationsAddList) {
                    if (((CreateVolumePermission)createVolumePermissionModificationsAddListValue).getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)((CreateVolumePermission)createVolumePermissionModificationsAddListValue).getGroup()));
                    }
                    if (((CreateVolumePermission)createVolumePermissionModificationsAddListValue).getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)((CreateVolumePermission)createVolumePermissionModificationsAddListValue).getUserId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(createVolumePermissionModificationsRemoveList = (SdkInternalList)createVolumePermission.getRemove()).isEmpty() || !createVolumePermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (CreateVolumePermission createVolumePermissionModificationsRemoveListValue : createVolumePermissionModificationsRemoveList) {
                    if (createVolumePermissionModificationsRemoveListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.getGroup()));
                    }
                    if (createVolumePermissionModificationsRemoveListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.getUserId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (!(modifySnapshotAttributeRequestGroupNamesList = (SdkInternalList)modifySnapshotAttributeRequest.getGroupNames()).isEmpty() || !modifySnapshotAttributeRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String modifySnapshotAttributeRequestGroupNamesListValue : modifySnapshotAttributeRequestGroupNamesList) {
                if (modifySnapshotAttributeRequestGroupNamesListValue != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifySnapshotAttributeRequest.getOperationType()));
        }
        if (modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (!(modifySnapshotAttributeRequestUserIdsList = (SdkInternalList)modifySnapshotAttributeRequest.getUserIds()).isEmpty() || !modifySnapshotAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (String modifySnapshotAttributeRequestUserIdsListValue : modifySnapshotAttributeRequestUserIdsList) {
                if (modifySnapshotAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        return request;
    }
}

