/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateCapacityReservationRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class CreateCapacityReservationRequestMarshaller
implements Marshaller<Request<CreateCapacityReservationRequest>, CreateCapacityReservationRequest> {
    public Request<CreateCapacityReservationRequest> marshall(CreateCapacityReservationRequest createCapacityReservationRequest) {
        SdkInternalList createCapacityReservationRequestTagSpecificationsList;
        if (createCapacityReservationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCapacityReservationRequest, "AmazonEC2");
        request.addParameter("Action", "CreateCapacityReservation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCapacityReservationRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createCapacityReservationRequest.getClientToken()));
        }
        if (createCapacityReservationRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)createCapacityReservationRequest.getInstanceType()));
        }
        if (createCapacityReservationRequest.getInstancePlatform() != null) {
            request.addParameter("InstancePlatform", StringUtils.fromString((String)createCapacityReservationRequest.getInstancePlatform()));
        }
        if (createCapacityReservationRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createCapacityReservationRequest.getAvailabilityZone()));
        }
        if (createCapacityReservationRequest.getAvailabilityZoneId() != null) {
            request.addParameter("AvailabilityZoneId", StringUtils.fromString((String)createCapacityReservationRequest.getAvailabilityZoneId()));
        }
        if (createCapacityReservationRequest.getTenancy() != null) {
            request.addParameter("Tenancy", StringUtils.fromString((String)createCapacityReservationRequest.getTenancy()));
        }
        if (createCapacityReservationRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)createCapacityReservationRequest.getInstanceCount()));
        }
        if (createCapacityReservationRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)createCapacityReservationRequest.getEbsOptimized()));
        }
        if (createCapacityReservationRequest.getEphemeralStorage() != null) {
            request.addParameter("EphemeralStorage", StringUtils.fromBoolean((Boolean)createCapacityReservationRequest.getEphemeralStorage()));
        }
        if (createCapacityReservationRequest.getEndDate() != null) {
            request.addParameter("EndDate", StringUtils.fromDate((Date)createCapacityReservationRequest.getEndDate()));
        }
        if (createCapacityReservationRequest.getEndDateType() != null) {
            request.addParameter("EndDateType", StringUtils.fromString((String)createCapacityReservationRequest.getEndDateType()));
        }
        if (createCapacityReservationRequest.getInstanceMatchCriteria() != null) {
            request.addParameter("InstanceMatchCriteria", StringUtils.fromString((String)createCapacityReservationRequest.getInstanceMatchCriteria()));
        }
        if (!(createCapacityReservationRequestTagSpecificationsList = (SdkInternalList)createCapacityReservationRequest.getTagSpecifications()).isEmpty() || !createCapacityReservationRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createCapacityReservationRequestTagSpecificationsListValue : createCapacityReservationRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createCapacityReservationRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecifications." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createCapacityReservationRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createCapacityReservationRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecifications." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecifications." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

