/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ExportEnvironment;
import com.amazonaws.services.ec2.model.ExportToS3TaskSpecification;
import com.amazonaws.services.ec2.model.transform.CreateInstanceExportTaskRequestMarshaller;
import java.io.Serializable;

public class CreateInstanceExportTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateInstanceExportTaskRequest> {
    private String description;
    private ExportToS3TaskSpecification exportToS3Task;
    private String instanceId;
    private String targetEnvironment;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateInstanceExportTaskRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setExportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
        this.exportToS3Task = exportToS3Task;
    }

    public ExportToS3TaskSpecification getExportToS3Task() {
        return this.exportToS3Task;
    }

    public CreateInstanceExportTaskRequest withExportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
        this.setExportToS3Task(exportToS3Task);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CreateInstanceExportTaskRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setTargetEnvironment(String targetEnvironment) {
        this.targetEnvironment = targetEnvironment;
    }

    public String getTargetEnvironment() {
        return this.targetEnvironment;
    }

    public CreateInstanceExportTaskRequest withTargetEnvironment(String targetEnvironment) {
        this.setTargetEnvironment(targetEnvironment);
        return this;
    }

    public void setTargetEnvironment(ExportEnvironment targetEnvironment) {
        this.withTargetEnvironment(targetEnvironment);
    }

    public CreateInstanceExportTaskRequest withTargetEnvironment(ExportEnvironment targetEnvironment) {
        this.targetEnvironment = targetEnvironment.toString();
        return this;
    }

    @Override
    public Request<CreateInstanceExportTaskRequest> getDryRunRequest() {
        Request<CreateInstanceExportTaskRequest> request = new CreateInstanceExportTaskRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getExportToS3Task() != null) {
            sb.append("ExportToS3Task: ").append(this.getExportToS3Task()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getTargetEnvironment() != null) {
            sb.append("TargetEnvironment: ").append(this.getTargetEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskRequest)) {
            return false;
        }
        CreateInstanceExportTaskRequest other = (CreateInstanceExportTaskRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getExportToS3Task() == null ^ this.getExportToS3Task() == null) {
            return false;
        }
        if (other.getExportToS3Task() != null && !other.getExportToS3Task().equals(this.getExportToS3Task())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getTargetEnvironment() == null ^ this.getTargetEnvironment() == null) {
            return false;
        }
        return other.getTargetEnvironment() == null || other.getTargetEnvironment().equals(this.getTargetEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getExportToS3Task() == null ? 0 : this.getExportToS3Task().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetEnvironment() == null ? 0 : this.getTargetEnvironment().hashCode());
        return hashCode;
    }

    public CreateInstanceExportTaskRequest clone() {
        return (CreateInstanceExportTaskRequest)super.clone();
    }
}

