/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

final class Ec2ClientSettings {
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.secureString((String)"discovery.ec2.access_key", null, (Setting.Property[])new Setting.Property[0]);
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.secureString((String)"discovery.ec2.secret_key", null, (Setting.Property[])new Setting.Property[0]);
    static final Setting<SecureString> SESSION_TOKEN_SETTING = SecureSetting.secureString((String)"discovery.ec2.session_token", null, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString((String)"discovery.ec2.proxy.host", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting((String)"discovery.ec2.proxy.port", (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> ENDPOINT_SETTING = new Setting("discovery.ec2.endpoint", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Protocol> PROTOCOL_SETTING = new Setting("discovery.ec2.protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<SecureString> PROXY_USERNAME_SETTING = SecureSetting.secureString((String)"discovery.ec2.proxy.username", null, (Setting.Property[])new Setting.Property[0]);
    static final Setting<SecureString> PROXY_PASSWORD_SETTING = SecureSetting.secureString((String)"discovery.ec2.proxy.password", null, (Setting.Property[])new Setting.Property[0]);
    static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting((String)"discovery.ec2.read_timeout", (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(Ec2ClientSettings.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(logger);
    final AWSCredentials credentials;
    final String endpoint;
    final Protocol protocol;
    final String proxyHost;
    final int proxyPort;
    final String proxyUsername;
    final String proxyPassword;
    final int readTimeoutMillis;

    protected Ec2ClientSettings(AWSCredentials credentials, String endpoint, Protocol protocol, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, int readTimeoutMillis) {
        this.credentials = credentials;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    /*
     * Exception decompiling
     */
    static AWSCredentials loadCredentials(Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Ec2ClientSettings getClientSettings(Settings settings) {
        AWSCredentials credentials = Ec2ClientSettings.loadCredentials(settings);
        try (SecureString proxyUsername = (SecureString)PROXY_USERNAME_SETTING.get(settings);){
            Ec2ClientSettings ec2ClientSettings;
            block12: {
                SecureString proxyPassword = (SecureString)PROXY_PASSWORD_SETTING.get(settings);
                try {
                    ec2ClientSettings = new Ec2ClientSettings(credentials, (String)ENDPOINT_SETTING.get(settings), (Protocol)PROTOCOL_SETTING.get(settings), (String)PROXY_HOST_SETTING.get(settings), (Integer)PROXY_PORT_SETTING.get(settings), proxyUsername.toString(), proxyPassword.toString(), (int)((TimeValue)READ_TIMEOUT_SETTING.get(settings)).millis());
                    if (proxyPassword == null) break block12;
                }
                catch (Throwable throwable) {
                    if (proxyPassword != null) {
                        try {
                            proxyPassword.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                proxyPassword.close();
            }
            return ec2ClientSettings;
        }
    }
}

