/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.discovery.ec2.AmazonEc2Reference;
import org.elasticsearch.discovery.ec2.AwsEc2Service;
import org.elasticsearch.discovery.ec2.Ec2ClientSettings;

class AwsEc2ServiceImpl
extends AbstractComponent
implements AwsEc2Service {
    public static final String EC2_METADATA_URL = "http://169.254.169.254/latest/meta-data/";
    private final AtomicReference<LazyInitializable<AmazonEc2Reference, ElasticsearchException>> lazyClientReference = new AtomicReference();

    AwsEc2ServiceImpl(Settings settings) {
        super(settings);
    }

    private AmazonEC2 buildClient(Ec2ClientSettings clientSettings) {
        AWSCredentialsProvider credentials = AwsEc2ServiceImpl.buildCredentials(this.logger, clientSettings);
        ClientConfiguration configuration = AwsEc2ServiceImpl.buildConfiguration(this.logger, clientSettings);
        AmazonEC2 client = this.buildClient(credentials, configuration);
        if (Strings.hasText((String)clientSettings.endpoint)) {
            this.logger.debug("using explicit ec2 endpoint [{}]", (Object)clientSettings.endpoint);
            client.setEndpoint(clientSettings.endpoint);
        }
        return client;
    }

    AmazonEC2 buildClient(AWSCredentialsProvider credentials, ClientConfiguration configuration) {
        AmazonEC2Client client = new AmazonEC2Client(credentials, configuration);
        return client;
    }

    static ClientConfiguration buildConfiguration(Logger logger, Ec2ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        Random rand = Randomness.get();
        RetryPolicy retryPolicy = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, (originalRequest, exception, retriesAttempted) -> {
            logger.warn("EC2 API request failed, retry again. Reason was:", (Throwable)exception);
            return 1000L * (long)(10.0 * Math.pow(2.0, (double)retriesAttempted / 2.0) * (1.0 + rand.nextDouble()));
        }, 10, false);
        clientConfiguration.setRetryPolicy(retryPolicy);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, Ec2ClientSettings clientSettings) {
        AWSCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using either environment variables, system properties or instance profile credentials");
            return new DefaultAWSCredentialsProviderChain();
        }
        logger.debug("Using basic key/secret credentials");
        return new StaticCredentialsProvider(credentials);
    }

    @Override
    public AmazonEc2Reference client() {
        LazyInitializable<AmazonEc2Reference, ElasticsearchException> clientReference = this.lazyClientReference.get();
        if (clientReference == null) {
            throw new IllegalStateException("Missing ec2 client configs");
        }
        return (AmazonEc2Reference)((Object)clientReference.getOrCompute());
    }

    @Override
    public void refreshAndClearCache(Ec2ClientSettings clientSettings) {
        LazyInitializable newClient = new LazyInitializable(() -> new AmazonEc2Reference(this.buildClient(clientSettings)), clientReference -> clientReference.incRef(), clientReference -> clientReference.decRef());
        LazyInitializable<AmazonEc2Reference, ElasticsearchException> oldClient = this.lazyClientReference.getAndSet((LazyInitializable<AmazonEc2Reference, ElasticsearchException>)newClient);
        if (oldClient != null) {
            oldClient.reset();
        }
    }

    @Override
    public void close() {
        LazyInitializable clientReference = this.lazyClientReference.getAndSet(null);
        if (clientReference != null) {
            clientReference.reset();
        }
        IdleConnectionReaper.shutdown();
    }
}

