/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.ec2.AwsEc2Service;
import org.elasticsearch.discovery.ec2.AwsEc2ServiceImpl;
import org.elasticsearch.discovery.ec2.AwsEc2UnicastHostsProvider;
import org.elasticsearch.discovery.ec2.Ec2NameResolver;
import org.elasticsearch.discovery.ec2.SocketAccess;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.TransportService;

public class Ec2DiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
Closeable {
    private static Logger logger = Loggers.getLogger(Ec2DiscoveryPlugin.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    public static final String EC2 = "ec2";
    private Settings settings;
    private final SetOnce<AwsEc2ServiceImpl> ec2Service = new SetOnce();

    public Ec2DiscoveryPlugin(Settings settings) {
        this.settings = settings;
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        logger.debug("Register _ec2_, _ec2:xxx_ network names");
        return new Ec2NameResolver(settings);
    }

    public Map<String, Supplier<UnicastHostsProvider>> getZenHostsProviders(TransportService transportService, NetworkService networkService) {
        return Collections.singletonMap(EC2, () -> {
            this.ec2Service.set((Object)new AwsEc2ServiceImpl(this.settings));
            return new AwsEc2UnicastHostsProvider(this.settings, transportService, (AwsEc2Service)this.ec2Service.get());
        });
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AwsEc2Service.ACCESS_KEY_SETTING, AwsEc2Service.SECRET_KEY_SETTING, AwsEc2Service.ENDPOINT_SETTING, AwsEc2Service.PROTOCOL_SETTING, AwsEc2Service.PROXY_HOST_SETTING, AwsEc2Service.PROXY_PORT_SETTING, AwsEc2Service.PROXY_USERNAME_SETTING, AwsEc2Service.PROXY_PASSWORD_SETTING, AwsEc2Service.READ_TIMEOUT_SETTING, AwsEc2Service.HOST_TYPE_SETTING, AwsEc2Service.ANY_GROUP_SETTING, AwsEc2Service.GROUPS_SETTING, AwsEc2Service.AVAILABILITY_ZONES_SETTING, AwsEc2Service.NODE_CACHE_TIME_SETTING, AwsEc2Service.TAG_SETTING, AwsEc2Service.AUTO_ATTRIBUTE_SETTING);
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        String azMetadataUrl = "http://169.254.169.254/latest/meta-data/placement/availability-zone";
        builder.put(Ec2DiscoveryPlugin.getAvailabilityZoneNodeAttributes(this.settings, azMetadataUrl));
        return builder.build();
    }

    @SuppressForbidden(reason="We call getInputStream in doPrivileged and provide SocketPermission")
    static Settings getAvailabilityZoneNodeAttributes(Settings settings, String azMetadataUrl) {
        URLConnection urlConnection;
        URL url;
        if (!((Boolean)AwsEc2Service.AUTO_ATTRIBUTE_SETTING.get(settings)).booleanValue()) {
            return Settings.EMPTY;
        }
        Settings.Builder attrs = Settings.builder();
        try {
            url = new URL(azMetadataUrl);
            logger.debug("obtaining ec2 [placement/availability-zone] from ec2 meta-data url {}", (Object)url);
            urlConnection = SocketAccess.doPrivilegedIOException(url::openConnection);
            urlConnection.setConnectTimeout(2000);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (InputStream in = SocketAccess.doPrivilegedIOException(urlConnection::getInputStream);
             BufferedReader urlReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String metadataResult = urlReader.readLine();
            if (metadataResult == null || metadataResult.length() == 0) {
                throw new IllegalStateException("no ec2 metadata returned from " + url);
            }
            attrs.put(Node.NODE_ATTRIBUTES.getKey() + "aws_availability_zone", metadataResult);
        }
        catch (IOException e) {
            logger.error("failed to get metadata for [placement/availability-zone]", (Throwable)e);
        }
        return attrs.build();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.ec2Service.get()});
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            try {
                Jackson.jsonNodeOf((String)"{}");
                Class.forName("com.amazonaws.ClientConfiguration");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

