/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.ec2.AwsEc2Service;

class AwsEc2ServiceImpl
extends AbstractComponent
implements AwsEc2Service,
Closeable {
    public static final String EC2_METADATA_URL = "http://169.254.169.254/latest/meta-data/";
    private AmazonEC2Client client;

    AwsEc2ServiceImpl(Settings settings) {
        super(settings);
    }

    @Override
    public synchronized AmazonEC2 client() {
        if (this.client != null) {
            return this.client;
        }
        this.client = new AmazonEC2Client(AwsEc2ServiceImpl.buildCredentials(this.logger, this.settings), AwsEc2ServiceImpl.buildConfiguration(this.logger, this.settings));
        String endpoint = AwsEc2ServiceImpl.findEndpoint(this.logger, this.settings);
        if (endpoint != null) {
            this.client.setEndpoint(endpoint);
        }
        return this.client;
    }

    protected static AWSCredentialsProvider buildCredentials(Logger logger, Settings settings) {
        DefaultAWSCredentialsProviderChain credentials;
        try (SecureString key = (SecureString)ACCESS_KEY_SETTING.get(settings);
             SecureString secret = (SecureString)SECRET_KEY_SETTING.get(settings);){
            if (key.length() == 0 && secret.length() == 0) {
                logger.debug("Using either environment variables, system properties or instance profile credentials");
                credentials = new DefaultAWSCredentialsProviderChain();
            } else {
                logger.debug("Using basic key/secret credentials");
                credentials = new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key.toString(), secret.toString()));
            }
        }
        return credentials;
    }

    protected static ClientConfiguration buildConfiguration(final Logger logger, Settings settings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol((Protocol)PROTOCOL_SETTING.get(settings));
        if (PROXY_HOST_SETTING.exists(settings)) {
            String proxyHost = (String)PROXY_HOST_SETTING.get(settings);
            Integer proxyPort = (Integer)PROXY_PORT_SETTING.get(settings);
            try (SecureString proxyUsername = (SecureString)PROXY_USERNAME_SETTING.get(settings);
                 SecureString proxyPassword = (SecureString)PROXY_PASSWORD_SETTING.get(settings);){
                clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername.toString()).withProxyPassword(proxyPassword.toString());
            }
        }
        final Random rand = Randomness.get();
        RetryPolicy retryPolicy = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, new RetryPolicy.BackoffStrategy(){

            public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
                logger.warn("EC2 API request failed, retry again. Reason was:", (Throwable)exception);
                return 1000L * (long)(10.0 * Math.pow(2.0, (double)retriesAttempted / 2.0) * (1.0 + rand.nextDouble()));
            }
        }, 10, false);
        clientConfiguration.setRetryPolicy(retryPolicy);
        clientConfiguration.setSocketTimeout((int)((TimeValue)READ_TIMEOUT_SETTING.get(settings)).millis());
        return clientConfiguration;
    }

    protected static String findEndpoint(Logger logger, Settings settings) {
        String endpoint = null;
        if (ENDPOINT_SETTING.exists(settings)) {
            endpoint = (String)ENDPOINT_SETTING.get(settings);
            logger.debug("using explicit ec2 endpoint [{}]", (Object)endpoint);
        }
        return endpoint;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

