/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFlowLogsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFlowLogsRequestMarshaller
implements Marshaller<Request<DescribeFlowLogsRequest>, DescribeFlowLogsRequest> {
    public Request<DescribeFlowLogsRequest> marshall(DescribeFlowLogsRequest describeFlowLogsRequest) {
        SdkInternalList filterList;
        if (describeFlowLogsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFlowLogs");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList flowLogIdsList = (SdkInternalList)describeFlowLogsRequest.getFlowLogIds();
        if (!flowLogIdsList.isEmpty() || !flowLogIdsList.isAutoConstruct()) {
            int flowLogIdsListIndex = 1;
            for (String flowLogIdsListValue : flowLogIdsList) {
                if (flowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString((String)flowLogIdsListValue));
                }
                ++flowLogIdsListIndex;
            }
        }
        if (!(filterList = (SdkInternalList)describeFlowLogsRequest.getFilter()).isEmpty() || !filterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter filterListValue : filterList) {
                SdkInternalList valuesList;
                if (filterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)filterListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filterListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeFlowLogsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFlowLogsRequest.getNextToken()));
        }
        if (describeFlowLogsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFlowLogsRequest.getMaxResults()));
        }
        return request;
    }
}

