/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.Protocol;
import com.amazonaws.services.ec2.AmazonEC2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

interface AwsEc2Service {
    public static final Setting<Boolean> AUTO_ATTRIBUTE_SETTING = Setting.boolSetting((String)"cloud.node.auto_attributes", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.secureString((String)"discovery.ec2.access_key", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.secureString((String)"discovery.ec2.secret_key", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<String> ENDPOINT_SETTING = new Setting("discovery.ec2.endpoint", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Protocol> PROTOCOL_SETTING = new Setting("discovery.ec2.protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString((String)"discovery.ec2.proxy.host", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting((String)"discovery.ec2.proxy.port", (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<SecureString> PROXY_USERNAME_SETTING = SecureSetting.secureString((String)"discovery.ec2.proxy.username", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> PROXY_PASSWORD_SETTING = SecureSetting.secureString((String)"discovery.ec2.proxy.password", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting((String)"discovery.ec2.read_timeout", (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> HOST_TYPE_SETTING = new Setting("discovery.ec2.host_type", "private_ip", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ANY_GROUP_SETTING = Setting.boolSetting((String)"discovery.ec2.any_group", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> GROUPS_SETTING = Setting.listSetting((String)"discovery.ec2.groups", new ArrayList(), s -> s.toString(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> AVAILABILITY_ZONES_SETTING = Setting.listSetting((String)"discovery.ec2.availability_zones", Collections.emptyList(), s -> s.toString(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> NODE_CACHE_TIME_SETTING = Setting.timeSetting((String)"discovery.ec2.node_cache_time", (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Settings> TAG_SETTING = Setting.groupSetting((String)"discovery.ec2.tag.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public AmazonEC2 client();

    public static class HostType {
        public static final String PRIVATE_IP = "private_ip";
        public static final String PUBLIC_IP = "public_ip";
        public static final String PRIVATE_DNS = "private_dns";
        public static final String PUBLIC_DNS = "public_dns";
        public static final String TAG_PREFIX = "tag:";
    }
}

