/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.SignerFactory;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;

class AwsSigner {
    private static final Logger logger = Loggers.getLogger(AwsSigner.class);

    private AwsSigner() {
    }

    protected static void validateSignerType(String signer) throws IllegalArgumentException {
        if (signer == null) {
            throw new IllegalArgumentException("[null] signer set");
        }
        try {
            SignerFactory.getSignerByTypeAndService((String)signer, null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("wrong signer set [" + signer + "]");
        }
    }

    public static void configureSigner(String signer, ClientConfiguration configuration) {
        try {
            AwsSigner.validateSignerType(signer);
        }
        catch (IllegalArgumentException e) {
            logger.warn("{}", (Object)e.getMessage());
        }
        configuration.setSignerOverride(signer);
    }
}

