/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.ec2.AwsEc2Service;
import org.elasticsearch.discovery.ec2.AwsSigner;

class AwsEc2ServiceImpl
extends AbstractComponent
implements AwsEc2Service,
Closeable {
    public static final String EC2_METADATA_URL = "http://169.254.169.254/latest/meta-data/";
    private AmazonEC2Client client;

    AwsEc2ServiceImpl(Settings settings) {
        super(settings);
    }

    @Override
    public synchronized AmazonEC2 client() {
        if (this.client != null) {
            return this.client;
        }
        this.client = new AmazonEC2Client(AwsEc2ServiceImpl.buildCredentials(this.logger, this.settings), AwsEc2ServiceImpl.buildConfiguration(this.logger, this.settings));
        String endpoint = AwsEc2ServiceImpl.findEndpoint(this.logger, this.settings);
        if (endpoint != null) {
            this.client.setEndpoint(endpoint);
        }
        return this.client;
    }

    protected static AWSCredentialsProvider buildCredentials(Logger logger, Settings settings) {
        DefaultAWSCredentialsProviderChain credentials;
        try (SecureString key = (SecureString)AwsEc2Service.DISCOVERY_EC2.ACCESS_KEY_SETTING.get(settings);
             SecureString secret = (SecureString)AwsEc2Service.DISCOVERY_EC2.SECRET_KEY_SETTING.get(settings);){
            if (key.length() == 0 && secret.length() == 0) {
                logger.debug("Using either environment variables, system properties or instance profile credentials");
                credentials = new DefaultAWSCredentialsProviderChain();
            } else {
                logger.debug("Using basic key/secret credentials");
                credentials = new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key.toString(), secret.toString()));
            }
        }
        return credentials;
    }

    protected static ClientConfiguration buildConfiguration(final Logger logger, Settings settings) {
        String awsSigner;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol((Protocol)AwsEc2Service.DISCOVERY_EC2.PROTOCOL_SETTING.get(settings));
        if (PROXY_HOST_SETTING.exists(settings) || AwsEc2Service.DISCOVERY_EC2.PROXY_HOST_SETTING.exists(settings)) {
            String proxyHost = (String)AwsEc2Service.DISCOVERY_EC2.PROXY_HOST_SETTING.get(settings);
            Integer proxyPort = (Integer)AwsEc2Service.DISCOVERY_EC2.PROXY_PORT_SETTING.get(settings);
            try (SecureString proxyUsername = (SecureString)AwsEc2Service.DISCOVERY_EC2.PROXY_USERNAME_SETTING.get(settings);
                 SecureString proxyPassword = (SecureString)AwsEc2Service.DISCOVERY_EC2.PROXY_PASSWORD_SETTING.get(settings);){
                clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername.toString()).withProxyPassword(proxyPassword.toString());
            }
        }
        if (Strings.hasText((String)(awsSigner = (String)AwsEc2Service.CLOUD_EC2.SIGNER_SETTING.get(settings)))) {
            logger.debug("using AWS API signer [{}]", (Object)awsSigner);
            AwsSigner.configureSigner(awsSigner, clientConfiguration);
        }
        final Random rand = Randomness.get();
        RetryPolicy retryPolicy = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, new RetryPolicy.BackoffStrategy(){

            public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
                logger.warn("EC2 API request failed, retry again. Reason was:", (Throwable)exception);
                return 1000L * (long)(10.0 * Math.pow(2.0, (double)retriesAttempted / 2.0) * (1.0 + rand.nextDouble()));
            }
        }, 10, false);
        clientConfiguration.setRetryPolicy(retryPolicy);
        clientConfiguration.setSocketTimeout((int)((TimeValue)AwsEc2Service.DISCOVERY_EC2.READ_TIMEOUT_SETTING.get(settings)).millis());
        return clientConfiguration;
    }

    protected static String findEndpoint(Logger logger, Settings settings) {
        String endpoint = null;
        if (AwsEc2Service.DISCOVERY_EC2.ENDPOINT_SETTING.exists(settings) || AwsEc2Service.CLOUD_EC2.ENDPOINT_SETTING.exists(settings)) {
            endpoint = (String)AwsEc2Service.DISCOVERY_EC2.ENDPOINT_SETTING.get(settings);
            logger.debug("using explicit ec2 endpoint [{}]", (Object)endpoint);
        } else if (REGION_SETTING.exists(settings) || AwsEc2Service.CLOUD_EC2.REGION_SETTING.exists(settings)) {
            String region;
            switch (region = (String)AwsEc2Service.CLOUD_EC2.REGION_SETTING.get(settings)) {
                case "us-east-1": 
                case "us-east": {
                    endpoint = "ec2.us-east-1.amazonaws.com";
                    break;
                }
                case "us-east-2": {
                    endpoint = "ec2.us-east-2.amazonaws.com";
                    break;
                }
                case "us-west": 
                case "us-west-1": {
                    endpoint = "ec2.us-west-1.amazonaws.com";
                    break;
                }
                case "us-west-2": {
                    endpoint = "ec2.us-west-2.amazonaws.com";
                    break;
                }
                case "ap-southeast": 
                case "ap-southeast-1": {
                    endpoint = "ec2.ap-southeast-1.amazonaws.com";
                    break;
                }
                case "ap-south": 
                case "ap-south-1": {
                    endpoint = "ec2.ap-south-1.amazonaws.com";
                    break;
                }
                case "us-gov-west": 
                case "us-gov-west-1": {
                    endpoint = "ec2.us-gov-west-1.amazonaws.com";
                    break;
                }
                case "ap-southeast-2": {
                    endpoint = "ec2.ap-southeast-2.amazonaws.com";
                    break;
                }
                case "ap-northeast": 
                case "ap-northeast-1": {
                    endpoint = "ec2.ap-northeast-1.amazonaws.com";
                    break;
                }
                case "ap-northeast-2": {
                    endpoint = "ec2.ap-northeast-2.amazonaws.com";
                    break;
                }
                case "eu-west": 
                case "eu-west-1": {
                    endpoint = "ec2.eu-west-1.amazonaws.com";
                    break;
                }
                case "eu-west-2": {
                    endpoint = "ec2.eu-west-2.amazonaws.com";
                    break;
                }
                case "eu-central": 
                case "eu-central-1": {
                    endpoint = "ec2.eu-central-1.amazonaws.com";
                    break;
                }
                case "sa-east": 
                case "sa-east-1": {
                    endpoint = "ec2.sa-east-1.amazonaws.com";
                    break;
                }
                case "cn-north": 
                case "cn-north-1": {
                    endpoint = "ec2.cn-north-1.amazonaws.com.cn";
                    break;
                }
                case "ca-central": 
                case "ca-central-1": {
                    endpoint = "ec2.ca-central-1.amazonaws.com";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
                }
            }
            logger.debug("using ec2 region [{}], with endpoint [{}]", (Object)region, (Object)endpoint);
        }
        return endpoint;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.shutdown();
        }
        IdleConnectionReaper.shutdown();
    }
}

