/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.Protocol;
import com.amazonaws.services.ec2.AmazonEC2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public interface AwsEc2Service {
    public static final Setting<Boolean> AUTO_ATTRIBUTE_SETTING = Setting.boolSetting((String)"cloud.node.auto_attributes", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> KEY_SETTING = Setting.simpleString((String)"cloud.aws.access_key", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Shared});
    public static final Setting<String> SECRET_SETTING = Setting.simpleString((String)"cloud.aws.secret_key", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Shared});
    public static final Setting<Protocol> PROTOCOL_SETTING = new Setting("cloud.aws.protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    public static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString((String)"cloud.aws.proxy.host", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    public static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting((String)"cloud.aws.proxy.port", (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    public static final Setting<String> PROXY_USERNAME_SETTING = Setting.simpleString((String)"cloud.aws.proxy.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    public static final Setting<String> PROXY_PASSWORD_SETTING = Setting.simpleString((String)"cloud.aws.proxy.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Shared});
    public static final Setting<String> SIGNER_SETTING = Setting.simpleString((String)"cloud.aws.signer", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    public static final Setting<String> REGION_SETTING = new Setting("cloud.aws.region", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    public static final Setting<TimeValue> READ_TIMEOUT = Setting.timeSetting((String)"cloud.aws.read_timeout", (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});

    public AmazonEC2 client();

    public static interface DISCOVERY_EC2 {
        public static final Setting<String> HOST_TYPE_SETTING = new Setting("discovery.ec2.host_type", "private_ip", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> ANY_GROUP_SETTING = Setting.boolSetting((String)"discovery.ec2.any_group", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<List<String>> GROUPS_SETTING = Setting.listSetting((String)"discovery.ec2.groups", new ArrayList(), s -> s.toString(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<List<String>> AVAILABILITY_ZONES_SETTING = Setting.listSetting((String)"discovery.ec2.availability_zones", Collections.emptyList(), s -> s.toString(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<TimeValue> NODE_CACHE_TIME_SETTING = Setting.timeSetting((String)"discovery.ec2.node_cache_time", (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Settings> TAG_SETTING = Setting.groupSetting((String)"discovery.ec2.tag.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

        public static class HostType {
            public static final String PRIVATE_IP = "private_ip";
            public static final String PUBLIC_IP = "public_ip";
            public static final String PRIVATE_DNS = "private_dns";
            public static final String PUBLIC_DNS = "public_dns";
            public static final String TAG_PREFIX = "tag:";
        }
    }

    public static interface CLOUD_EC2 {
        public static final Setting<String> KEY_SETTING = new Setting("cloud.aws.ec2.access_key", KEY_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> SECRET_SETTING = new Setting("cloud.aws.ec2.secret_key", SECRET_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<Protocol> PROTOCOL_SETTING = new Setting("cloud.aws.ec2.protocol", PROTOCOL_SETTING, s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> PROXY_HOST_SETTING = new Setting("cloud.aws.ec2.proxy.host", PROXY_HOST_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Integer> PROXY_PORT_SETTING = new Setting("cloud.aws.ec2.proxy.port", PROXY_PORT_SETTING, s -> Setting.parseInt((String)s, (int)0, (int)65536, (String)"cloud.aws.ec2.proxy.port"), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> PROXY_USERNAME_SETTING = new Setting("cloud.aws.ec2.proxy.username", PROXY_USERNAME_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> PROXY_PASSWORD_SETTING = new Setting("cloud.aws.ec2.proxy.password", PROXY_PASSWORD_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
        public static final Setting<String> SIGNER_SETTING = new Setting("cloud.aws.ec2.signer", SIGNER_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> REGION_SETTING = new Setting("cloud.aws.ec2.region", REGION_SETTING, s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> ENDPOINT_SETTING = Setting.simpleString((String)"cloud.aws.ec2.endpoint", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<TimeValue> READ_TIMEOUT = Setting.timeSetting((String)"cloud.aws.ec2.read_timeout", READ_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

