/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cloud.aws.AwsEc2Service;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class AwsEc2UnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    private final TransportService transportService;
    private final AmazonEC2 client;
    private final boolean bindAnyGroup;
    private final Set<String> groups;
    private final Map<String, String> tags;
    private final Set<String> availabilityZones;
    private final AwsEc2Service.DISCOVERY_EC2.HostType hostType;
    private final DiscoNodesCache discoNodes;

    public AwsEc2UnicastHostsProvider(Settings settings, TransportService transportService, AwsEc2Service awsEc2Service) {
        super(settings);
        this.transportService = transportService;
        this.client = awsEc2Service.client();
        this.hostType = (AwsEc2Service.DISCOVERY_EC2.HostType)((Object)AwsEc2Service.DISCOVERY_EC2.HOST_TYPE_SETTING.get(settings));
        this.discoNodes = new DiscoNodesCache((TimeValue)AwsEc2Service.DISCOVERY_EC2.NODE_CACHE_TIME_SETTING.get(settings));
        this.bindAnyGroup = (Boolean)AwsEc2Service.DISCOVERY_EC2.ANY_GROUP_SETTING.get(settings);
        this.groups = new HashSet<String>();
        this.groups.addAll((Collection)AwsEc2Service.DISCOVERY_EC2.GROUPS_SETTING.get(settings));
        this.tags = ((Settings)AwsEc2Service.DISCOVERY_EC2.TAG_SETTING.get(settings)).getAsMap();
        this.availabilityZones = new HashSet<String>();
        this.availabilityZones.addAll((Collection)AwsEc2Service.DISCOVERY_EC2.AVAILABILITY_ZONES_SETTING.get(settings));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using host_type [{}], tags [{}], groups [{}] with any_group [{}], availability_zones [{}]", (Object)this.hostType, this.tags, this.groups, (Object)this.bindAnyGroup, this.availabilityZones);
        }
    }

    public List<DiscoveryNode> buildDynamicNodes() {
        return (List)this.discoNodes.getOrRefresh();
    }

    protected List<DiscoveryNode> fetchDynamicNodes() {
        DescribeInstancesResult descInstances;
        ArrayList<DiscoveryNode> discoNodes = new ArrayList<DiscoveryNode>();
        try {
            descInstances = this.client.describeInstances(this.buildDescribeInstancesRequest());
        }
        catch (AmazonClientException e) {
            this.logger.info("Exception while retrieving instance list from AWS API: {}", (Object)e.getMessage());
            this.logger.debug("Full exception:", (Throwable)e);
            return discoNodes;
        }
        this.logger.trace("building dynamic unicast discovery nodes...");
        for (Reservation reservation : descInstances.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                if (!this.groups.isEmpty()) {
                    List instanceSecurityGroups = instance.getSecurityGroups();
                    ArrayList<String> securityGroupNames = new ArrayList<String>();
                    ArrayList<String> securityGroupIds = new ArrayList<String>();
                    for (GroupIdentifier sg : instanceSecurityGroups) {
                        securityGroupNames.add(sg.getGroupName());
                        securityGroupIds.add(sg.getGroupId());
                    }
                    if (this.bindAnyGroup) {
                        if (Collections.disjoint(securityGroupNames, this.groups) && Collections.disjoint(securityGroupIds, this.groups)) {
                            this.logger.trace("filtering out instance {} based on groups {}, not part of {}", (Object)instance.getInstanceId(), (Object)instanceSecurityGroups, this.groups);
                            continue;
                        }
                    } else if (!securityGroupNames.containsAll(this.groups) && !securityGroupIds.containsAll(this.groups)) {
                        this.logger.trace("filtering out instance {} based on groups {}, does not include all of {}", (Object)instance.getInstanceId(), (Object)instanceSecurityGroups, this.groups);
                        continue;
                    }
                }
                String address = null;
                switch (this.hostType) {
                    case PRIVATE_DNS: {
                        address = instance.getPrivateDnsName();
                        break;
                    }
                    case PRIVATE_IP: {
                        address = instance.getPrivateIpAddress();
                        break;
                    }
                    case PUBLIC_DNS: {
                        address = instance.getPublicDnsName();
                        break;
                    }
                    case PUBLIC_IP: {
                        address = instance.getPublicIpAddress();
                    }
                }
                if (address != null) {
                    try {
                        TransportAddress[] addresses = this.transportService.addressesFromString(address, 1);
                        for (int i = 0; i < addresses.length; ++i) {
                            this.logger.trace("adding {}, address {}, transport_address {}", (Object)instance.getInstanceId(), (Object)address, (Object)addresses[i]);
                            discoNodes.add(new DiscoveryNode("#cloud-" + instance.getInstanceId() + "-" + i, addresses[i], Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumCompatibilityVersion()));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        String finalAddress = address;
                        this.logger.warn(() -> new ParameterizedMessage("failed to add {}, address {}", (Object)instance.getInstanceId(), (Object)finalAddress), (Throwable)e);
                        continue;
                    }
                }
                this.logger.trace("not adding {}, address is null, host_type {}", (Object)instance.getInstanceId(), (Object)this.hostType);
            }
        }
        this.logger.debug("using dynamic discovery nodes {}", discoNodes);
        return discoNodes;
    }

    private DescribeInstancesRequest buildDescribeInstancesRequest() {
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("instance-state-name").withValues(new String[]{"running", "pending"})});
        for (Map.Entry<String, String> tagFilter : this.tags.entrySet()) {
            describeInstancesRequest.withFilters(new Filter[]{new Filter("tag:" + tagFilter.getKey()).withValues(new String[]{tagFilter.getValue()})});
        }
        if (!this.availabilityZones.isEmpty()) {
            describeInstancesRequest.withFilters(new Filter[]{new Filter("availability-zone").withValues(this.availabilityZones)});
        }
        return describeInstancesRequest;
    }

    private final class DiscoNodesCache
    extends SingleObjectCache<List<DiscoveryNode>> {
        private boolean empty;

        protected DiscoNodesCache(TimeValue refreshInterval) {
            super(refreshInterval, new ArrayList());
            this.empty = true;
        }

        protected boolean needsRefresh() {
            return this.empty || super.needsRefresh();
        }

        protected List<DiscoveryNode> refresh() {
            List<DiscoveryNode> nodes = AwsEc2UnicastHostsProvider.this.fetchDynamicNodes();
            this.empty = nodes.isEmpty();
            return nodes;
        }
    }
}

