/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.discovery.ec2;

import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cloud.aws.AwsEc2Service;
import org.elasticsearch.cloud.aws.AwsEc2ServiceImpl;
import org.elasticsearch.cloud.aws.Ec2Module;
import org.elasticsearch.cloud.aws.network.Ec2NameResolver;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.ec2.AwsEc2UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;

public class Ec2DiscoveryPlugin
extends Plugin
implements DiscoveryPlugin {
    private static Logger logger = Loggers.getLogger(Ec2DiscoveryPlugin.class);
    public static final String EC2 = "ec2";
    private Settings settings;

    public Ec2DiscoveryPlugin(Settings settings) {
        this.settings = settings;
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add((Module)new Ec2Module());
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        services.add(AwsEc2ServiceImpl.class);
        return services;
    }

    public void onModule(DiscoveryModule discoveryModule) {
        discoveryModule.addDiscoveryType(EC2, ZenDiscovery.class);
        discoveryModule.addUnicastHostProvider(EC2, AwsEc2UnicastHostsProvider.class);
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings settings) {
        logger.debug("Register _ec2_, _ec2:xxx_ network names");
        return new Ec2NameResolver(settings);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AwsEc2Service.KEY_SETTING, AwsEc2Service.SECRET_SETTING, AwsEc2Service.PROTOCOL_SETTING, AwsEc2Service.PROXY_HOST_SETTING, AwsEc2Service.PROXY_PORT_SETTING, AwsEc2Service.PROXY_USERNAME_SETTING, AwsEc2Service.PROXY_PASSWORD_SETTING, AwsEc2Service.SIGNER_SETTING, AwsEc2Service.REGION_SETTING, AwsEc2Service.CLOUD_EC2.KEY_SETTING, AwsEc2Service.CLOUD_EC2.SECRET_SETTING, AwsEc2Service.CLOUD_EC2.PROTOCOL_SETTING, AwsEc2Service.CLOUD_EC2.PROXY_HOST_SETTING, AwsEc2Service.CLOUD_EC2.PROXY_PORT_SETTING, AwsEc2Service.CLOUD_EC2.PROXY_USERNAME_SETTING, AwsEc2Service.CLOUD_EC2.PROXY_PASSWORD_SETTING, AwsEc2Service.CLOUD_EC2.SIGNER_SETTING, AwsEc2Service.CLOUD_EC2.REGION_SETTING, AwsEc2Service.CLOUD_EC2.ENDPOINT_SETTING, AwsEc2Service.DISCOVERY_EC2.HOST_TYPE_SETTING, AwsEc2Service.DISCOVERY_EC2.ANY_GROUP_SETTING, AwsEc2Service.DISCOVERY_EC2.GROUPS_SETTING, AwsEc2Service.DISCOVERY_EC2.AVAILABILITY_ZONES_SETTING, AwsEc2Service.DISCOVERY_EC2.NODE_CACHE_TIME_SETTING, AwsEc2Service.DISCOVERY_EC2.TAG_SETTING, AwsEc2Service.AUTO_ATTRIBUTE_SETTING);
    }

    public Settings additionalSettings() {
        return Ec2DiscoveryPlugin.getAvailabilityZoneNodeAttributes(this.settings, "http://169.254.169.254/latest/meta-data/placement/availability-zone");
    }

    static Settings getAvailabilityZoneNodeAttributes(Settings settings, String azMetadataUrl) {
        URLConnection urlConnection;
        URL url;
        if (!((Boolean)AwsEc2Service.AUTO_ATTRIBUTE_SETTING.get(settings)).booleanValue()) {
            return Settings.EMPTY;
        }
        Settings.Builder attrs = Settings.builder();
        try {
            url = new URL(azMetadataUrl);
            logger.debug("obtaining ec2 [placement/availability-zone] from ec2 meta-data url {}", (Object)url);
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(2000);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (InputStream in = urlConnection.getInputStream();
             BufferedReader urlReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String metadataResult = urlReader.readLine();
            if (metadataResult == null || metadataResult.length() == 0) {
                throw new IllegalStateException("no ec2 metadata returned from " + url);
            }
            attrs.put(Node.NODE_ATTRIBUTES.getKey() + "aws_availability_zone", metadataResult);
        }
        catch (IOException e) {
            logger.error("failed to get metadata for [placement/availability-zone]", (Throwable)e);
        }
        return attrs.build();
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Jackson.jsonNodeOf((String)"{}");
                    Class.forName("com.amazonaws.ClientConfiguration");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }
}

