/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class AnalyzerProfile {
    public static String ANALYSIS_DATA_DIR = "";

    private static void init() {
        Path[] candidateFiles;
        String dirName = "analysis-data";
        String propName = "analysis.properties";
        ANALYSIS_DATA_DIR = System.getProperty("analysis.data.dir", "");
        if (ANALYSIS_DATA_DIR.length() != 0) {
            return;
        }
        for (Path file : candidateFiles = new Path[]{Paths.get(dirName, new String[0]), Paths.get("lib", new String[0]).resolve(dirName), Paths.get(propName, new String[0]), Paths.get("lib", new String[0]).resolve(propName)}) {
            if (!Files.exists(file, new LinkOption[0])) continue;
            if (Files.isDirectory(file, new LinkOption[0])) {
                ANALYSIS_DATA_DIR = file.toAbsolutePath().toString();
                break;
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) || AnalyzerProfile.getAnalysisDataDir(file).length() == 0) break;
            ANALYSIS_DATA_DIR = AnalyzerProfile.getAnalysisDataDir(file).toString();
            break;
        }
        if (ANALYSIS_DATA_DIR.length() == 0) {
            throw new RuntimeException("WARNING: Can not find lexical dictionary directory! This will cause unpredictable exceptions in your application! Please refer to the manual to download the dictionaries.");
        }
    }

    private static String getAnalysisDataDir(Path propFile) {
        String string;
        block8: {
            Properties prop = new Properties();
            BufferedReader reader = Files.newBufferedReader(propFile, StandardCharsets.UTF_8);
            try {
                prop.load(reader);
                string = prop.getProperty("analysis.data.dir", "");
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "";
                }
            }
            reader.close();
        }
        return string;
    }

    static {
        AnalyzerProfile.init();
    }
}

