/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.phonetic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class KoelnerPhonetik
implements StringEncoder {
    private static final String[] POSTEL_VARIATIONS_PATTERNS = new String[]{"AUN", "OWN", "RB", "RW", "WSK", "RSK"};
    private static final String[] POSTEL_VARIATIONS_REPLACEMENTS = new String[]{"OWN", "AUN", "RW", "RB", "RSK", "WSK"};
    private Pattern[] variationsPatterns;
    private boolean primary = false;
    private final Set<Character> csz = new HashSet<Character>(Arrays.asList(Character.valueOf('C'), Character.valueOf('S'), Character.valueOf('Z')));
    private final Set<Character> ckq = new HashSet<Character>(Arrays.asList(Character.valueOf('C'), Character.valueOf('K'), Character.valueOf('Q')));
    private final Set<Character> aouhkxq = new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('O'), Character.valueOf('U'), Character.valueOf('H'), Character.valueOf('K'), Character.valueOf('X'), Character.valueOf('Q')));
    private final Set<Character> ahkloqrux = new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('H'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('O'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('U'), Character.valueOf('X')));

    public KoelnerPhonetik() {
        this.init();
    }

    public KoelnerPhonetik(boolean useOnlyPrimaryCode) {
        this();
        this.primary = useOnlyPrimaryCode;
    }

    protected String[] getPatterns() {
        return POSTEL_VARIATIONS_PATTERNS;
    }

    protected String[] getReplacements() {
        return POSTEL_VARIATIONS_REPLACEMENTS;
    }

    protected char getCode() {
        return '0';
    }

    public double getRelativeValue(Object o1, Object o2) {
        String[] kopho1 = this.code(KoelnerPhonetik.expandUmlauts(o1.toString().toUpperCase(Locale.GERMANY)));
        String[] kopho2 = this.code(KoelnerPhonetik.expandUmlauts(o2.toString().toUpperCase(Locale.GERMANY)));
        for (int i = 0; i < kopho1.length; ++i) {
            for (int ii = 0; ii < kopho2.length; ++ii) {
                if (!kopho1[i].equals(kopho2[ii])) continue;
                return 1.0;
            }
        }
        return 0.0;
    }

    public Object encode(Object str) throws EncoderException {
        return this.encode((String)str);
    }

    public String encode(String str) throws EncoderException {
        if (str == null) {
            return null;
        }
        String[] s = this.code(str.toString());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]);
            if (i >= s.length - 1) continue;
            sb.append('_');
        }
        return sb.toString();
    }

    private void init() {
        this.variationsPatterns = new Pattern[this.getPatterns().length];
        for (int i = 0; i < this.getPatterns().length; ++i) {
            this.variationsPatterns[i] = Pattern.compile(this.getPatterns()[i]);
        }
    }

    private String[] code(String str) {
        List<String> parts = this.partition(str);
        String[] codes = new String[parts.size()];
        int i = 0;
        for (String s : parts) {
            codes[i++] = this.substitute(s);
        }
        return codes;
    }

    private List<String> partition(String str) {
        String primaryForm = str;
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(primaryForm.replaceAll("[^\\p{L}\\p{N}]", ""));
        if (!this.primary) {
            ArrayList<String> tmpParts = new ArrayList<String>(Arrays.asList(str.split("[\\p{Z}\\p{C}\\p{P}]")));
            int numberOfParts = tmpParts.size();
            while (tmpParts.size() > 0) {
                StringBuilder part = new StringBuilder();
                for (int i = 0; i < tmpParts.size(); ++i) {
                    part.append((String)tmpParts.get(i));
                    if (i + 1 == numberOfParts) continue;
                    parts.add(part.toString());
                }
                tmpParts.remove(0);
            }
        }
        ArrayList<String> variations = new ArrayList<String>();
        for (int i = 0; i < parts.size(); ++i) {
            List<String> variation = this.getVariations((String)parts.get(i));
            if (variation == null) continue;
            variations.addAll(variation);
        }
        return variations;
    }

    private List<String> getVariations(String str) {
        int position = 0;
        ArrayList<String> variations = new ArrayList<String>();
        variations.add("");
        while (position < str.length()) {
            int i;
            int substPos = -1;
            for (i = 0; substPos < position && i < this.getPatterns().length; ++i) {
                Matcher m = this.variationsPatterns[i].matcher(str);
                while (substPos < position && m.find()) {
                    substPos = m.start();
                }
            }
            if (substPos >= position) {
                --i;
                ArrayList<String> varNew = new ArrayList<String>();
                String prevPart = str.substring(position, substPos);
                for (int ii = 0; ii < variations.size(); ++ii) {
                    String tmp = (String)variations.get(ii);
                    varNew.add(tmp.concat(prevPart + this.getReplacements()[i]));
                    variations.set(ii, (String)variations.get(ii) + prevPart + this.getPatterns()[i]);
                }
                variations.addAll(varNew);
                position = substPos + this.getPatterns()[i].length();
                continue;
            }
            for (int ii = 0; ii < variations.size(); ++ii) {
                variations.set(ii, (String)variations.get(ii) + str.substring(position, str.length()));
            }
            position = str.length();
        }
        return variations;
    }

    private String substitute(String str) {
        String s = KoelnerPhonetik.expandUmlauts(str.toUpperCase(Locale.GERMAN));
        s = KoelnerPhonetik.removeSequences(s);
        StringBuilder sb = new StringBuilder();
        block14: for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            char next = i + 1 < s.length() ? (char)s.charAt(i + 1) : (char)'_';
            char prev = i > 0 ? (char)s.charAt(i - 1) : (char)'_';
            switch (current) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'J': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (i != 0 && (i != 1 || prev != 72)) continue block14;
                    sb.append(this.getCode());
                    continue block14;
                }
                case 'P': {
                    sb.append(next == 'H' ? "33" : Character.valueOf('1'));
                    continue block14;
                }
                case 'B': {
                    sb.append('1');
                    continue block14;
                }
                case 'D': 
                case 'T': {
                    sb.append(this.csz.contains(Character.valueOf(next)) ? (char)'8' : '2');
                    continue block14;
                }
                case 'F': 
                case 'V': 
                case 'W': {
                    sb.append('3');
                    continue block14;
                }
                case 'G': 
                case 'K': 
                case 'Q': {
                    sb.append('4');
                    continue block14;
                }
                case 'C': {
                    if (i == 0) {
                        sb.append(this.ahkloqrux.contains(Character.valueOf(next)) ? (char)'4' : '8');
                    } else {
                        sb.append(this.aouhkxq.contains(Character.valueOf(next)) ? (char)'4' : '8');
                    }
                    if (sb.length() < 2 || sb.charAt(sb.length() - 2) != '8') continue block14;
                    sb.setCharAt(sb.length() - 1, '8');
                    continue block14;
                }
                case 'X': {
                    sb.append(i < 1 || !this.ckq.contains(Character.valueOf(prev)) ? "48" : Character.valueOf('8'));
                    continue block14;
                }
                case 'L': {
                    sb.append('5');
                    continue block14;
                }
                case 'M': 
                case 'N': {
                    sb.append('6');
                    continue block14;
                }
                case 'R': {
                    sb.append('7');
                    continue block14;
                }
                case 'S': 
                case 'Z': {
                    sb.append('8');
                    continue block14;
                }
            }
        }
        s = sb.toString();
        s = KoelnerPhonetik.removeSequences(s);
        return s;
    }

    private static String expandUmlauts(String str) {
        return str.replace("\u00c4", "AE").replace("\u00d6", "OE").replace("\u00dc", "UE");
    }

    private static String removeSequences(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int i = 0;
        int j = 0;
        StringBuilder sb = new StringBuilder().append(str.charAt(i++));
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != sb.charAt(j)) {
                sb.append(c);
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }
}

