/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.codec.Encoder;
import org.apache.commons.codec.language.Caverphone1;
import org.apache.commons.codec.language.Caverphone2;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DaitchMokotoffSoundex;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.BeiderMorseFilter;
import org.apache.lucene.analysis.phonetic.DoubleMetaphoneFilter;
import org.apache.lucene.analysis.phonetic.PhoneticFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.phonetic.HaasePhonetik;
import org.elasticsearch.index.analysis.phonetic.KoelnerPhonetik;
import org.elasticsearch.index.analysis.phonetic.Nysiis;

public class PhoneticTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Encoder encoder;
    private final boolean replace;
    private int maxcodelength = 0;
    private String[] languageset = null;
    private NameType nametype = null;
    private RuleType ruletype = null;

    public PhoneticTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.replace = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "replace", Boolean.valueOf(true), this.deprecationLogger);
        String encodername = settings.get("encoder", "metaphone");
        if ("metaphone".equalsIgnoreCase(encodername)) {
            this.encoder = new Metaphone();
        } else if ("soundex".equalsIgnoreCase(encodername)) {
            this.encoder = new Soundex();
        } else if ("caverphone1".equalsIgnoreCase(encodername)) {
            this.encoder = new Caverphone1();
        } else if ("caverphone2".equalsIgnoreCase(encodername)) {
            this.encoder = new Caverphone2();
        } else if ("caverphone".equalsIgnoreCase(encodername)) {
            this.encoder = new Caverphone2();
        } else if ("refined_soundex".equalsIgnoreCase(encodername) || "refinedSoundex".equalsIgnoreCase(encodername)) {
            this.encoder = new RefinedSoundex();
        } else if ("cologne".equalsIgnoreCase(encodername)) {
            this.encoder = new ColognePhonetic();
        } else if ("double_metaphone".equalsIgnoreCase(encodername) || "doubleMetaphone".equalsIgnoreCase(encodername)) {
            this.encoder = null;
            this.maxcodelength = settings.getAsInt("max_code_len", Integer.valueOf(4));
        } else if ("bm".equalsIgnoreCase(encodername) || "beider_morse".equalsIgnoreCase(encodername) || "beidermorse".equalsIgnoreCase(encodername)) {
            this.encoder = null;
            this.languageset = settings.getAsArray("languageset");
            String ruleType = settings.get("rule_type", "approx");
            if ("approx".equalsIgnoreCase(ruleType)) {
                this.ruletype = RuleType.APPROX;
            } else if ("exact".equalsIgnoreCase(ruleType)) {
                this.ruletype = RuleType.EXACT;
            } else {
                throw new IllegalArgumentException("No matching rule type [" + ruleType + "] for beider morse encoder");
            }
            String nameType = settings.get("name_type", "generic");
            if ("GENERIC".equalsIgnoreCase(nameType)) {
                this.nametype = NameType.GENERIC;
            } else if ("ASHKENAZI".equalsIgnoreCase(nameType)) {
                this.nametype = NameType.ASHKENAZI;
            } else if ("SEPHARDIC".equalsIgnoreCase(nameType)) {
                this.nametype = NameType.SEPHARDIC;
            }
        } else if ("koelnerphonetik".equalsIgnoreCase(encodername)) {
            this.encoder = new KoelnerPhonetik();
        } else if ("haasephonetik".equalsIgnoreCase(encodername)) {
            this.encoder = new HaasePhonetik();
        } else if ("nysiis".equalsIgnoreCase(encodername)) {
            this.encoder = new Nysiis();
        } else if ("daitch_mokotoff".equalsIgnoreCase(encodername)) {
            this.encoder = new DaitchMokotoffSoundex();
        } else {
            throw new IllegalArgumentException("unknown encoder [" + encodername + "] for phonetic token filter");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.encoder == null) {
            if (this.ruletype != null && this.nametype != null) {
                Languages.LanguageSet langset = null;
                if (this.languageset != null && this.languageset.length > 0) {
                    langset = Languages.LanguageSet.from(new HashSet<String>(Arrays.asList(this.languageset)));
                }
                return new BeiderMorseFilter(tokenStream, new PhoneticEngine(this.nametype, this.ruletype, true), langset);
            }
            if (this.maxcodelength > 0) {
                return new DoubleMetaphoneFilter(tokenStream, this.maxcodelength, !this.replace);
            }
        } else {
            return new PhoneticFilter(tokenStream, this.encoder, !this.replace);
        }
        throw new IllegalArgumentException("encoder error");
    }
}

