/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.nori;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.Analysis;

public class NoriTokenizerFactory
extends AbstractTokenizerFactory {
    private static final String USER_DICT_PATH_OPTION = "user_dictionary";
    private static final String USER_DICT_RULES_OPTION = "user_dictionary_rules";
    private static final String LENIENT = "lenient";
    private final UserDictionary userDictionary;
    private final KoreanTokenizer.DecompoundMode decompoundMode;
    private final boolean discardPunctuation;

    public NoriTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        this.decompoundMode = NoriTokenizerFactory.getMode(settings);
        this.userDictionary = NoriTokenizerFactory.getUserDictionary(env, settings, indexSettings);
        this.discardPunctuation = settings.getAsBoolean("discard_punctuation", Boolean.valueOf(true));
    }

    public static UserDictionary getUserDictionary(Environment env, Settings settings, IndexSettings indexSettings) {
        UserDictionary userDictionary;
        if (settings.get(USER_DICT_PATH_OPTION) != null && settings.get(USER_DICT_RULES_OPTION) != null) {
            throw new IllegalArgumentException("It is not allowed to use [user_dictionary] in conjunction with [user_dictionary_rules]");
        }
        List ruleList = Analysis.getWordList((Environment)env, (Settings)settings, (String)USER_DICT_PATH_OPTION, (String)USER_DICT_RULES_OPTION, (String)LENIENT, (boolean)false, (boolean)NoriTokenizerFactory.isSupportDuplicateCheck(indexSettings));
        if (ruleList == null || ruleList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : ruleList) {
            sb.append(line).append(System.lineSeparator());
        }
        StringReader rulesReader = new StringReader(sb.toString());
        try {
            userDictionary = UserDictionary.open((Reader)rulesReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)rulesReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to load nori user dictionary", (Throwable)e, new Object[0]);
            }
        }
        ((Reader)rulesReader).close();
        return userDictionary;
    }

    private static boolean isSupportDuplicateCheck(IndexSettings indexSettings) {
        IndexVersion idxVersion = indexSettings.getIndexVersionCreated();
        return idxVersion.onOrAfter((VersionId)IndexVersions.NORI_DUPLICATES) && idxVersion != IndexVersions.UPGRADE_LUCENE_9_9_1;
    }

    public static KoreanTokenizer.DecompoundMode getMode(Settings settings) {
        String modeSetting = settings.get("decompound_mode", KoreanTokenizer.DEFAULT_DECOMPOUND.name());
        return KoreanTokenizer.DecompoundMode.valueOf((String)modeSetting.toUpperCase(Locale.ENGLISH));
    }

    public Tokenizer create() {
        return new KoreanTokenizer(KoreanTokenizer.DEFAULT_TOKEN_ATTRIBUTE_FACTORY, this.userDictionary, this.decompoundMode, false, this.discardPunctuation);
    }
}

