/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.nori;

import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.ko.KoreanAnalyzer;
import org.apache.lucene.analysis.ko.KoreanPartOfSpeechStopFilter;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.plugin.analysis.nori.NoriPartOfSpeechStopFilterFactory;
import org.elasticsearch.plugin.analysis.nori.NoriTokenizerFactory;

public class NoriAnalyzerProvider
extends AbstractIndexAnalyzerProvider<KoreanAnalyzer> {
    private final KoreanAnalyzer analyzer;

    public NoriAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        KoreanTokenizer.DecompoundMode mode = NoriTokenizerFactory.getMode(settings);
        UserDictionary userDictionary = NoriTokenizerFactory.getUserDictionary(env, settings);
        List tagList = Analysis.getWordList((Environment)env, (Settings)settings, (String)"stoptags");
        Set<POS.Tag> stopTags = tagList != null ? NoriPartOfSpeechStopFilterFactory.resolvePOSList(tagList) : KoreanPartOfSpeechStopFilter.DEFAULT_STOP_TAGS;
        this.analyzer = new KoreanAnalyzer(userDictionary, mode, stopTags, false);
    }

    public KoreanAnalyzer get() {
        return this.analyzer;
    }
}

