/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.util.Locale;

public class POS {
    public static Tag resolveTag(String name) {
        String tagUpper = name.toUpperCase(Locale.ENGLISH);
        if (tagUpper.startsWith("J")) {
            return Tag.J;
        }
        if (tagUpper.startsWith("E")) {
            return Tag.E;
        }
        return Tag.valueOf(tagUpper);
    }

    public static Tag resolveTag(byte tag) {
        assert (tag < Tag.values().length);
        return Tag.values()[tag];
    }

    public static Type resolveType(String name) {
        if ("*".equals(name)) {
            return Type.MORPHEME;
        }
        return Type.valueOf(name.toUpperCase(Locale.ENGLISH));
    }

    public static Type resolveType(byte type) {
        assert (type < Type.values().length);
        return Type.values()[type];
    }

    public static enum Tag {
        E(100, "Verbal endings"),
        IC(110, "Interjection"),
        J(120, "Ending Particle"),
        MAG(130, "General Adverb"),
        MAJ(131, "Conjunctive adverb"),
        MM(140, "Modifier"),
        NNG(150, "General Noun"),
        NNP(151, "Proper Noun"),
        NNB(152, "Dependent noun"),
        NNBC(153, "Dependent noun"),
        NP(154, "Pronoun"),
        NR(155, "Numeral"),
        SF(160, "Terminal punctuation"),
        SH(161, "Chinese Characeter"),
        SL(162, "Foreign language"),
        SN(163, "Number"),
        SP(164, "Space"),
        SSC(165, "Closing brackets"),
        SSO(166, "Opening brackets"),
        SC(167, "Separator"),
        SY(168, "Other symbol"),
        SE(169, "Ellipsis"),
        VA(170, "Adjective"),
        VCN(171, "Negative designator"),
        VCP(172, "Positive designator"),
        VV(173, "Verb"),
        VX(174, "Auxiliary Verb or Adjective"),
        XPN(181, "Prefix"),
        XR(182, "Root"),
        XSA(183, "Adjective Suffix"),
        XSN(184, "Noun Suffix"),
        XSV(185, "Verb Suffix"),
        UNKNOWN(999, "Unknown"),
        UNA(-1, "Unknown"),
        NA(-1, "Unknown"),
        VSV(-1, "Unknown");

        private final int code;
        private final String desc;

        public int code() {
            return this.code;
        }

        public String description() {
            return this.desc;
        }

        private Tag(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    public static enum Type {
        MORPHEME,
        COMPOUND,
        INFLECT,
        PREANALYSIS;

    }
}

